/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeType;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

class ZonedDateTimeArrayType
extends AbstractArrayType<ZonedDateTime> {
    ZonedDateTimeArrayType(byte typeId) {
        super(ValueGroup.ZONED_DATE_TIME_ARRAY, typeId, (o1, o2, i) -> ZonedDateTimeType.compare(o1.long0Array[i], o1.long1Array[i], o1.long2Array[i], o1.long3Array[i], o2.long0Array[i], o2.long1Array[i], o2.long2Array[i], o2.long3Array[i]), (k, i) -> ZonedDateTimeType.asValueRaw(k.long0Array[i], k.long1Array[i], k.long2Array[i], k.long3Array[i]), (c, k, i) -> ZonedDateTimeType.put(c, k.long0Array[i], k.long1Array[i], k.long2Array[i], k.long3Array[i]), ZonedDateTimeType::read, ZonedDateTime[]::new, ValueWriter.ArrayType.ZONED_DATE_TIME);
    }

    @Override
    int valueSize(GenericKey state) {
        return this.arrayKeySize(state, 16);
    }

    @Override
    void copyValue(GenericKey to2, GenericKey from2, int length2) {
        this.initializeArray(to2, length2, null);
        System.arraycopy(from2.long0Array, 0, to2.long0Array, 0, length2);
        System.arraycopy(from2.long1Array, 0, to2.long1Array, 0, length2);
        System.arraycopy(from2.long2Array, 0, to2.long2Array, 0, length2);
        System.arraycopy(from2.long3Array, 0, to2.long3Array, 0, length2);
    }

    @Override
    void initializeArray(GenericKey key, int length2, ValueWriter.ArrayType arrayType) {
        key.long0Array = ZonedDateTimeArrayType.ensureBigEnough(key.long0Array, length2);
        key.long1Array = ZonedDateTimeArrayType.ensureBigEnough(key.long1Array, length2);
        key.long2Array = ZonedDateTimeArrayType.ensureBigEnough(key.long2Array, length2);
        key.long3Array = ZonedDateTimeArrayType.ensureBigEnough(key.long3Array, length2);
    }

    void write(GenericKey state, int offset, long epochSecondUTC, int nano, short zoneId, int offsetSeconds) {
        state.long0Array[offset] = epochSecondUTC;
        state.long1Array[offset] = nano;
        state.long2Array[offset] = zoneId;
        state.long3Array[offset] = offsetSeconds;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0Array=" + Arrays.toString(state.long0Array));
        joiner.add("long1Array=" + Arrays.toString(state.long1Array));
        joiner.add("long2Array=" + Arrays.toString(state.long2Array));
        joiner.add("long3Array=" + Arrays.toString(state.long3Array));
        super.addTypeSpecificDetails(joiner, state);
    }
}

