/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialIndexFiles {
    private static final Pattern CRS_DIR_PATTERN = Pattern.compile("(\\d+)-(\\d+)");
    private final FileSystemAbstraction fs;
    private final ConfiguredSpaceFillingCurveSettingsCache configuredSettings;
    private final File indexDirectory;

    SpatialIndexFiles(IndexDirectoryStructure directoryStructure, long indexId, FileSystemAbstraction fs, ConfiguredSpaceFillingCurveSettingsCache settingsCache) {
        this.fs = fs;
        this.configuredSettings = settingsCache;
        this.indexDirectory = directoryStructure.directoryForIndex(indexId);
    }

    Iterable<SpatialFile> existing() {
        ArrayList<SpatialFile> existing = new ArrayList<SpatialFile>();
        this.addExistingFiles(existing);
        return existing;
    }

    <T> void loadExistingIndexes(SpatialIndexCache<T> indexCache) throws IOException {
        for (SpatialFile fileLayout : this.existing()) {
            indexCache.select(fileLayout.crs);
        }
    }

    SpatialFile forCrs(CoordinateReferenceSystem crs) {
        return new SpatialFile(crs, this.configuredSettings, this.indexDirectory);
    }

    private void addExistingFiles(List<SpatialFile> existing) {
        File[] files2 = this.fs.listFiles(this.indexDirectory);
        if (files2 != null) {
            for (File file : files2) {
                String name = file.getName();
                Matcher matcher = CRS_DIR_PATTERN.matcher(name);
                if (!matcher.matches()) continue;
                int tableId = Integer.parseInt(matcher.group(1));
                int code = Integer.parseInt(matcher.group(2));
                CoordinateReferenceSystem crs = CoordinateReferenceSystem.get(tableId, code);
                existing.add(this.forCrs(crs));
            }
        }
    }

    static class SpatialFileLayout {
        final SpaceFillingCurveSettings settings;
        final SpatialFile spatialFile;
        final IndexLayout<SpatialIndexKey, NativeIndexValue> layout;

        SpatialFileLayout(SpatialFile spatialFile, SpaceFillingCurveSettings settings) {
            this.spatialFile = spatialFile;
            this.settings = settings;
            this.layout = new SpatialLayout(spatialFile.crs, settings.curve());
        }

        public File getIndexFile() {
            return this.spatialFile.indexFile;
        }
    }

    static class SpatialFile {
        final File indexFile;
        final ConfiguredSpaceFillingCurveSettingsCache configuredSettings;
        final CoordinateReferenceSystem crs;

        SpatialFile(CoordinateReferenceSystem crs, ConfiguredSpaceFillingCurveSettingsCache configuredSettings, File indexDirectory) {
            this.crs = crs;
            this.configuredSettings = configuredSettings;
            String s2 = crs.getTable().getTableId() + "-" + Integer.toString(crs.getCode());
            this.indexFile = new File(indexDirectory, s2);
        }

        SpatialFileLayout getLayoutForNewIndex() {
            return new SpatialFileLayout(this, this.configuredSettings.forCRS(this.crs));
        }

        SpatialFileLayout getLayoutForExistingIndex(PageCache pageCache) throws IOException {
            SpaceFillingCurveSettings settings = SpaceFillingCurveSettingsFactory.fromGBPTree(this.indexFile, pageCache, NativeIndexHeaderReader::readFailureMessage);
            return new SpatialFileLayout(this, settings);
        }
    }
}

