/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.util.VisibleForTesting;

public class IndexDefineCommand
extends Command {
    static final int HIGHEST_POSSIBLE_ID = 65534;
    private final AtomicInteger nextIndexNameId = new AtomicInteger();
    private final AtomicInteger nextKeyId = new AtomicInteger();
    private MutableObjectIntMap<String> indexNameIdRange = new ObjectIntHashMap();
    private MutableObjectIntMap<String> keyIdRange = new ObjectIntHashMap();
    private MutableIntObjectMap<String> idToIndexName = new IntObjectHashMap();
    private MutableIntObjectMap<String> idToKey = new IntObjectHashMap();

    public void init(MutableObjectIntMap<String> indexNames, MutableObjectIntMap<String> keys) {
        this.indexNameIdRange = Objects.requireNonNull(indexNames, "indexNames");
        this.keyIdRange = Objects.requireNonNull(keys, "keys");
        this.idToIndexName = indexNames.flipUniqueValues();
        this.idToKey = keys.flipUniqueValues();
    }

    private static String getFromMap(IntObjectMap<String> map2, int id2) {
        if (id2 == -1) {
            return null;
        }
        String result2 = (String)map2.get(id2);
        if (result2 == null) {
            throw new IllegalArgumentException(String.valueOf(id2));
        }
        return result2;
    }

    public String getIndexName(int id2) {
        return IndexDefineCommand.getFromMap(this.idToIndexName, id2);
    }

    public String getKey(int id2) {
        return IndexDefineCommand.getFromMap(this.idToKey, id2);
    }

    public int getOrAssignIndexNameId(String indexName) {
        return this.getOrAssignId(this.indexNameIdRange, this.idToIndexName, this.nextIndexNameId, indexName);
    }

    public int getOrAssignKeyId(String key) {
        return this.getOrAssignId(this.keyIdRange, this.idToKey, this.nextKeyId, key);
    }

    private int getOrAssignId(MutableObjectIntMap<String> stringToId, MutableIntObjectMap<String> idToString, AtomicInteger nextId, String string2) {
        if (string2 == null) {
            return -1;
        }
        if (stringToId.containsKey((Object)string2)) {
            return stringToId.get((Object)string2);
        }
        int id2 = nextId.incrementAndGet();
        if (id2 > 65534 || stringToId.size() >= 65534) {
            throw new IllegalStateException(String.format("Modifying more than %d indexes or keys in a single transaction is not supported", 65535));
        }
        stringToId.put((Object)string2, id2);
        idToString.put(id2, (Object)string2);
        return id2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexDefineCommand that = (IndexDefineCommand)o;
        return this.nextIndexNameId.get() == that.nextIndexNameId.get() && this.nextKeyId.get() == that.nextKeyId.get() && Objects.equals(this.indexNameIdRange, that.indexNameIdRange) && Objects.equals(this.keyIdRange, that.keyIdRange) && Objects.equals(this.idToIndexName, that.idToIndexName) && Objects.equals(this.idToKey, that.idToKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextIndexNameId.get(), this.nextKeyId.get(), this.indexNameIdRange, this.keyIdRange, this.idToIndexName, this.idToKey);
    }

    @Override
    public boolean handle(CommandVisitor visitor) throws IOException {
        return visitor.visitIndexDefineCommand(this);
    }

    @VisibleForTesting
    ObjectIntMap<String> getIndexNameIdRange() {
        return this.indexNameIdRange;
    }

    @VisibleForTesting
    ObjectIntMap<String> getKeyIdRange() {
        return this.keyIdRange;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[names:" + this.indexNameIdRange + ", keys:" + this.keyIdRange + "]";
    }

    public void serialize(WritableChannel channel) throws IOException {
        channel.put((byte)10);
        byte zero = 0;
        IndexCommand.writeIndexCommandHeader(channel, zero, zero, zero, zero, zero, zero, zero);
        try {
            IndexDefineCommand.writeMap(channel, this.indexNameIdRange);
            IndexDefineCommand.writeMap(channel, this.keyIdRange);
        }
        catch (UncheckedIOException e) {
            throw new IOException(e);
        }
    }

    private static void writeMap(WritableChannel channel, ObjectIntMap<String> map2) throws IOException {
        assert (map2.size() <= 65534) : "Can not write map with size larger than 2 bytes. Actual size " + map2.size();
        channel.putShort((short)map2.size());
        map2.forEachKeyValue((ObjectIntProcedure & Serializable)(key, id2) -> {
            assert (id2 <= 65534) : "Can not write id larger than 2 bytes. Actual value " + id2;
            try {
                IoPrimitiveUtils.write2bLengthAndString(channel, key);
                channel.putShort((short)id2);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

