/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import org.neo4j.kernel.api.KernelTransactionHandle;

public class KernelTransactionsSnapshot {
    private Tx relevantTransactions;
    private final long snapshotTime;

    public KernelTransactionsSnapshot(Set<KernelTransactionHandle> allTransactions, long snapshotTime) {
        Tx head2 = null;
        for (KernelTransactionHandle tx : allTransactions) {
            if (!tx.isOpen()) continue;
            Tx current = new Tx(tx);
            if (head2 != null) {
                current.next = head2;
                head2 = current;
                continue;
            }
            head2 = current;
        }
        this.relevantTransactions = head2;
        this.snapshotTime = snapshotTime;
    }

    public boolean allClosed() {
        while (this.relevantTransactions != null) {
            if (!this.relevantTransactions.haveClosed()) {
                return false;
            }
            this.relevantTransactions = this.relevantTransactions.next;
        }
        return true;
    }

    public long snapshotTime() {
        return this.snapshotTime;
    }

    private static class Tx {
        private final KernelTransactionHandle transaction;
        private Tx next;

        Tx(KernelTransactionHandle tx) {
            this.transaction = tx;
        }

        boolean haveClosed() {
            return !this.transaction.isOpen();
        }
    }
}

