/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.InternalPair;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.MapAccessor;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.driver.v1.util.Function;
import org.neo4j.driver.v1.util.Pair;

public final class Extract {
    private Extract() {
        throw new UnsupportedOperationException();
    }

    public static List<Value> list(Value[] values2) {
        switch (values2.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(values2[0]);
            }
        }
        return Collections.unmodifiableList(Arrays.asList(values2));
    }

    public static <T> List<T> list(Value[] data, Function<Value, T> mapFunction) {
        int size2 = data.length;
        switch (size2) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(mapFunction.apply(data[0]));
            }
        }
        ArrayList<T> result2 = new ArrayList<T>(size2);
        for (Value value2 : data) {
            result2.add(mapFunction.apply(value2));
        }
        return Collections.unmodifiableList(result2);
    }

    public static <T> Map<String, T> map(Map<String, Value> data, Function<Value, T> mapFunction) {
        if (data.isEmpty()) {
            return Collections.emptyMap();
        }
        int size2 = data.size();
        if (size2 == 1) {
            Map.Entry<String, Value> head2 = data.entrySet().iterator().next();
            return Collections.singletonMap(head2.getKey(), mapFunction.apply(head2.getValue()));
        }
        LinkedHashMap<String, T> map2 = Iterables.newLinkedHashMapWithSize(size2);
        for (Map.Entry<String, Value> entry : data.entrySet()) {
            map2.put(entry.getKey(), mapFunction.apply(entry.getValue()));
        }
        return Collections.unmodifiableMap(map2);
    }

    public static <T> Map<String, T> map(Record record, Function<Value, T> mapFunction) {
        int size2 = record.size();
        switch (size2) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap(record.keys().get(0), mapFunction.apply(record.get(0)));
            }
        }
        LinkedHashMap<String, T> map2 = Iterables.newLinkedHashMapWithSize(size2);
        List<String> keys = record.keys();
        for (int i = 0; i < size2; ++i) {
            map2.put(keys.get(i), mapFunction.apply(record.get(i)));
        }
        return Collections.unmodifiableMap(map2);
    }

    public static <V> Iterable<Pair<String, V>> properties(MapAccessor map2, Function<Value, V> mapFunction) {
        int size2 = map2.size();
        switch (size2) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                String key = map2.keys().iterator().next();
                Value value2 = map2.get(key);
                return Collections.singletonList(InternalPair.of(key, mapFunction.apply(value2)));
            }
        }
        ArrayList<Pair<String, V>> list2 = new ArrayList<Pair<String, V>>(size2);
        for (String key : map2.keys()) {
            Value value3 = map2.get(key);
            list2.add(InternalPair.of(key, mapFunction.apply(value3)));
        }
        return Collections.unmodifiableList(list2);
    }

    public static <V> List<Pair<String, V>> fields(Record map2, Function<Value, V> mapFunction) {
        int size2 = map2.keys().size();
        switch (size2) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                String key = map2.keys().iterator().next();
                Value value2 = map2.get(key);
                return Collections.singletonList(InternalPair.of(key, mapFunction.apply(value2)));
            }
        }
        ArrayList<Pair<String, V>> list2 = new ArrayList<Pair<String, V>>(size2);
        List<String> keys = map2.keys();
        for (int i = 0; i < size2; ++i) {
            String key = keys.get(i);
            Value value3 = map2.get(i);
            list2.add(InternalPair.of(key, mapFunction.apply(value3)));
        }
        return Collections.unmodifiableList(list2);
    }

    public static Map<String, Value> mapOfValues(Map<String, Object> map2) {
        if (map2 == null || map2.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> result2 = Iterables.newHashMapWithSize(map2.size());
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            Object value2 = entry.getValue();
            Extract.assertParameter(value2);
            result2.put(entry.getKey(), Values.value(value2));
        }
        return result2;
    }

    public static void assertParameter(Object value2) {
        if (value2 instanceof Node || value2 instanceof NodeValue) {
            throw new ClientException("Nodes can't be used as parameters.");
        }
        if (value2 instanceof Relationship || value2 instanceof RelationshipValue) {
            throw new ClientException("Relationships can't be used as parameters.");
        }
        if (value2 instanceof Path || value2 instanceof PathValue) {
            throw new ClientException("Paths can't be used as parameters.");
        }
    }
}

