/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

public enum DynamicStore {
    SCHEMA(RecordType.SCHEMA){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.schema(block);
        }
    }
    ,
    STRING(RecordType.STRING_PROPERTY){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.string(block);
        }
    }
    ,
    ARRAY(RecordType.ARRAY_PROPERTY){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.array(block);
        }
    }
    ,
    PROPERTY_KEY(RecordType.PROPERTY_KEY_NAME){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.propertyKeyName((int)block);
        }
    }
    ,
    RELATIONSHIP_TYPE(RecordType.RELATIONSHIP_TYPE_NAME){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.relationshipTypeName((int)block);
        }
    }
    ,
    LABEL(RecordType.LABEL_NAME){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.labelName((int)block);
        }
    }
    ,
    NODE_LABEL(RecordType.NODE_DYNAMIC_LABEL){

        @Override
        RecordReference<DynamicRecord> lookup(RecordAccess records, long block) {
            return records.nodeLabels(block);
        }
    };

    public final RecordType type;

    private DynamicStore(RecordType type) {
        this.type = type;
    }

    abstract RecordReference<DynamicRecord> lookup(RecordAccess var1, long var2);
}

