/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.index.LuceneDocumentRetrievalException;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;

public class LucenePartitionAllDocumentsReader
implements BoundedIterable<Document> {
    private final PartitionSearcher partitionSearcher;
    private final IndexSearcher searcher;
    private final IndexReader reader;

    public LucenePartitionAllDocumentsReader(PartitionSearcher partitionSearcher) {
        this.partitionSearcher = partitionSearcher;
        this.searcher = partitionSearcher.getIndexSearcher();
        this.reader = this.searcher.getIndexReader();
    }

    public long maxCount() {
        return this.reader.maxDoc();
    }

    public Iterator<Document> iterator() {
        return new PrefetchingIterator<Document>(){
            DocIdSetIterator idIterator;
            {
                this.idIterator = LucenePartitionAllDocumentsReader.this.iterateAllDocs();
            }

            protected Document fetchNextOrNull() {
                try {
                    int doc = this.idIterator.nextDoc();
                    if (doc == Integer.MAX_VALUE) {
                        return null;
                    }
                    return LucenePartitionAllDocumentsReader.this.getDocument(doc);
                }
                catch (IOException e) {
                    throw new LuceneDocumentRetrievalException("Can't fetch document id from lucene index.", e);
                }
            }
        };
    }

    public void close() throws IOException {
        this.partitionSearcher.close();
    }

    private Document getDocument(int docId) {
        try {
            return this.searcher.doc(docId);
        }
        catch (IOException e) {
            throw new LuceneDocumentRetrievalException("Can't retrieve document with id: " + docId + ".", docId, e);
        }
    }

    private DocIdSetIterator iterateAllDocs() {
        final Bits liveDocs = MultiFields.getLiveDocs((IndexReader)this.reader);
        DocIdSetIterator allDocs = DocIdSetIterator.all((int)this.reader.maxDoc());
        if (liveDocs == null) {
            return allDocs;
        }
        return new FilteredDocIdSetIterator(allDocs){

            protected boolean match(int doc) {
                return liveDocs.get(doc);
            }
        };
    }
}

