/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TextValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CharValue
extends TextValue {
    final char value;

    CharValue(char value2) {
        this.value = value2;
    }

    @Override
    public boolean eq(Object other2) {
        return other2 instanceof Value && this.equals((Value)other2);
    }

    @Override
    public boolean equals(Value other2) {
        return other2.equals(this.value);
    }

    @Override
    public boolean equals(char x) {
        return this.value == x;
    }

    @Override
    public boolean equals(String x) {
        return x.length() == 1 && x.charAt(0) == this.value;
    }

    @Override
    public int computeHash() {
        return 31 + this.value;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return CharValue.updateHash(hashFunction, hash, this.value);
    }

    public static long updateHash(HashFunction hashFunction, long hash, char value2) {
        hash = hashFunction.update(hash, value2);
        return hashFunction.update(hash, 1L);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.value);
    }

    @Override
    public Object asObjectCopy() {
        return Character.valueOf(this.value);
    }

    @Override
    public String prettyPrint() {
        return String.format("'%s'", Character.valueOf(this.value));
    }

    @Override
    public String stringValue() {
        return Character.toString(this.value);
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public TextValue substring(int start, int length2) {
        if (length2 != 1 && start != 0) {
            return StringValue.EMPTY;
        }
        return this;
    }

    @Override
    public TextValue trim() {
        if (Character.isWhitespace(this.value)) {
            return StringValue.EMPTY;
        }
        return this;
    }

    @Override
    public TextValue ltrim() {
        return this.trim();
    }

    @Override
    public TextValue rtrim() {
        return this.trim();
    }

    @Override
    public TextValue toLower() {
        return new CharValue(Character.toLowerCase(this.value));
    }

    @Override
    public TextValue toUpper() {
        return new CharValue(Character.toUpperCase(this.value));
    }

    @Override
    public ListValue split(String separator) {
        if (separator.equals(this.stringValue())) {
            return EMPTY_SPLIT;
        }
        return VirtualValues.list(Values.stringValue(this.stringValue()));
    }

    @Override
    public TextValue replace(String find2, String replace2) {
        assert (find2 != null);
        assert (replace2 != null);
        if (this.stringValue().equals(find2)) {
            return Values.stringValue(replace2);
        }
        return this;
    }

    @Override
    public TextValue reverse() {
        return this;
    }

    @Override
    public TextValue plus(TextValue other2) {
        return Values.stringValue(this.value + other2.stringValue());
    }

    @Override
    public boolean startsWith(TextValue other2) {
        return other2.length() == 1 && other2.stringValue().charAt(0) == this.value;
    }

    @Override
    public boolean endsWith(TextValue other2) {
        return this.startsWith(other2);
    }

    @Override
    public boolean contains(TextValue other2) {
        return this.startsWith(other2);
    }

    public char value() {
        return this.value;
    }

    @Override
    public int compareTo(TextValue other2) {
        return TextValues.compareCharToString(this.value, other2.stringValue());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapChar(this);
    }

    @Override
    Matcher matcher(Pattern pattern) {
        return pattern.matcher("" + this.value);
    }

    public String toString() {
        return String.format("%s('%s')", this.getTypeName(), Character.valueOf(this.value));
    }

    @Override
    public String getTypeName() {
        return "Char";
    }
}

