/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Numbers;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.memory.GlobalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.ChunkedNumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCachedNumberArrayFactory;
import org.neo4j.unsafe.impl.internal.dragons.NativeMemoryAllocationRefusedError;

public interface NumberArrayFactory {
    public static final Monitor NO_MONITOR = (memory, successfulFactory, attemptedAllocationFailures) -> {};
    public static final NumberArrayFactory HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length2, int defaultValue, long base) {
            return new HeapIntArray(Numbers.safeCastLongToInt(length2), defaultValue, base);
        }

        @Override
        public LongArray newLongArray(long length2, long defaultValue, long base) {
            return new HeapLongArray(Numbers.safeCastLongToInt(length2), defaultValue, base);
        }

        @Override
        public ByteArray newByteArray(long length2, byte[] defaultValue, long base) {
            return new HeapByteArray(Numbers.safeCastLongToInt(length2), defaultValue, base);
        }

        public String toString() {
            return "HEAP";
        }
    };
    public static final NumberArrayFactory OFF_HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length2, int defaultValue, long base) {
            return new OffHeapIntArray(length2, defaultValue, base, GlobalMemoryTracker.INSTANCE);
        }

        @Override
        public LongArray newLongArray(long length2, long defaultValue, long base) {
            return new OffHeapLongArray(length2, defaultValue, base, (MemoryAllocationTracker)GlobalMemoryTracker.INSTANCE);
        }

        @Override
        public ByteArray newByteArray(long length2, byte[] defaultValue, long base) {
            return new OffHeapByteArray(length2, defaultValue, base, (MemoryAllocationTracker)GlobalMemoryTracker.INSTANCE);
        }

        public String toString() {
            return "OFF_HEAP";
        }
    };
    public static final NumberArrayFactory CHUNKED_FIXED_SIZE = new ChunkedNumberArrayFactory(NO_MONITOR);
    public static final NumberArrayFactory AUTO_WITHOUT_PAGECACHE = new Auto(NO_MONITOR, OFF_HEAP, HEAP, CHUNKED_FIXED_SIZE);

    public static NumberArrayFactory auto(PageCache pageCache, File dir, boolean allowHeapAllocation, Monitor monitor) {
        PageCachedNumberArrayFactory pagedArrayFactory = new PageCachedNumberArrayFactory(pageCache, dir);
        ChunkedNumberArrayFactory chunkedArrayFactory = new ChunkedNumberArrayFactory(monitor, NumberArrayFactory.allocationAlternatives(allowHeapAllocation, pagedArrayFactory));
        return new Auto(monitor, NumberArrayFactory.allocationAlternatives(allowHeapAllocation, chunkedArrayFactory));
    }

    public static NumberArrayFactory[] allocationAlternatives(boolean allowHeapAllocation, NumberArrayFactory ... additional) {
        ArrayList<NumberArrayFactory> result2 = new ArrayList<NumberArrayFactory>(Collections.singletonList(OFF_HEAP));
        if (allowHeapAllocation) {
            result2.add(HEAP);
        }
        result2.addAll(Arrays.asList(additional));
        return result2.toArray(new NumberArrayFactory[result2.size()]);
    }

    default public IntArray newIntArray(long length2, int defaultValue) {
        return this.newIntArray(length2, defaultValue, 0L);
    }

    public IntArray newIntArray(long var1, int var3, long var4);

    public IntArray newDynamicIntArray(long var1, int var3);

    default public LongArray newLongArray(long length2, long defaultValue) {
        return this.newLongArray(length2, defaultValue, 0L);
    }

    public LongArray newLongArray(long var1, long var3, long var5);

    public LongArray newDynamicLongArray(long var1, long var3);

    default public ByteArray newByteArray(long length2, byte[] defaultValue) {
        return this.newByteArray(length2, defaultValue, 0L);
    }

    public ByteArray newByteArray(long var1, byte[] var3, long var4);

    public ByteArray newDynamicByteArray(long var1, byte[] var3);

    public static abstract class Adapter
    implements NumberArrayFactory {
        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
            return new DynamicIntArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
            return new DynamicLongArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }

        @Override
        public ByteArray newDynamicByteArray(long chunkSize, byte[] defaultValue) {
            return new DynamicByteArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }
    }

    public static class Auto
    extends Adapter {
        private final Monitor monitor;
        private final NumberArrayFactory[] candidates;

        public Auto(Monitor monitor, NumberArrayFactory ... candidates) {
            Objects.requireNonNull(monitor);
            this.monitor = monitor;
            this.candidates = candidates;
        }

        @Override
        public LongArray newLongArray(long length2, long defaultValue, long base) {
            return this.tryAllocate(length2, 8, f -> f.newLongArray(length2, defaultValue, base));
        }

        @Override
        public IntArray newIntArray(long length2, int defaultValue, long base) {
            return this.tryAllocate(length2, 4, f -> f.newIntArray(length2, defaultValue, base));
        }

        @Override
        public ByteArray newByteArray(long length2, byte[] defaultValue, long base) {
            return this.tryAllocate(length2, defaultValue.length, f -> f.newByteArray(length2, defaultValue, base));
        }

        private <T extends NumberArray<? extends T>> T tryAllocate(long length2, int itemSize, Function<NumberArrayFactory, T> allocator) {
            ArrayList<AllocationFailure> failures = new ArrayList<AllocationFailure>();
            Throwable error = null;
            for (NumberArrayFactory candidate : this.candidates) {
                try {
                    try {
                        NumberArray array = (NumberArray)allocator.apply(candidate);
                        this.monitor.allocationSuccessful(length2 * (long)itemSize, candidate, failures);
                        return (T)array;
                    }
                    catch (ArithmeticException e) {
                        throw new OutOfMemoryError(e.getMessage());
                    }
                }
                catch (OutOfMemoryError | NativeMemoryAllocationRefusedError e) {
                    if (error == null) {
                        error = e;
                    } else {
                        e.addSuppressed(error);
                        error = e;
                    }
                    failures.add(new AllocationFailure(e, candidate));
                }
            }
            throw this.error(length2, itemSize, (Error)error);
        }

        private Error error(long length2, int itemSize, Error error) {
            return Exceptions.withMessage(error, String.format("%s: Not enough memory available for allocating %s, tried %s", error.getMessage(), Format.bytes(length2 * (long)itemSize), Arrays.toString(this.candidates)));
        }
    }

    public static class AllocationFailure {
        private final Throwable failure;
        private final NumberArrayFactory factory;

        AllocationFailure(Throwable failure, NumberArrayFactory factory) {
            this.failure = failure;
            this.factory = factory;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public NumberArrayFactory getFactory() {
            return this.factory;
        }
    }

    public static interface Monitor {
        public void allocationSuccessful(long var1, NumberArrayFactory var3, Iterable<AllocationFailure> var4);
    }
}

