/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class KernelData
extends LifecycleAdapter {
    private static final Map<String, KernelData> instances = new ConcurrentHashMap<String, KernelData>();
    private final String instanceId;
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final File storeDir;
    private final Config configuration;
    private final DataSourceManager dataSourceManager;

    public KernelData(FileSystemAbstraction fs, PageCache pageCache, File storeDir, Config configuration, DataSourceManager dataSourceManager) {
        this.pageCache = pageCache;
        this.fs = fs;
        this.storeDir = storeDir;
        this.configuration = configuration;
        this.dataSourceManager = dataSourceManager;
        this.instanceId = KernelData.newInstance(this);
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public Version version() {
        return Version.getKernel();
    }

    public File getStoreDir() {
        return this.storeDir;
    }

    public Config getConfig() {
        return this.configuration;
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public FileSystemAbstraction getFilesystemAbstraction() {
        return this.fs;
    }

    public DataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    @Override
    public void shutdown() {
        KernelData.removeInstance(this.instanceId);
    }

    public final int hashCode() {
        return this.instanceId.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj instanceof KernelData && this.instanceId.equals(((KernelData)obj).instanceId);
    }

    private static synchronized String newInstance(KernelData instance2) {
        String instanceId = instance2.configuration.get(GraphDatabaseSettings.forced_kernel_id);
        if (StringUtils.isEmpty(instanceId)) {
            for (int i = 0; i < instances.size() + 1 && instances.containsKey(instanceId = Integer.toString(i)); ++i) {
            }
        }
        if (instances.containsKey(instanceId)) {
            throw new IllegalStateException("There is already a kernel started with " + GraphDatabaseSettings.forced_kernel_id.name() + "='" + instanceId + "'.");
        }
        instances.put(instanceId, instance2);
        return instanceId;
    }

    private static synchronized void removeInstance(String instanceId) {
        if (instances.remove(instanceId) == null) {
            throw new IllegalArgumentException("No kernel found with instance id " + instanceId);
        }
    }
}

