/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.function.Function;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.util.NodeProxyWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipProxyWrappingValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class DefaultValueMapper
extends ValueMapper.JavaMapper {
    private final EmbeddedProxySPI proxySPI;

    public DefaultValueMapper(EmbeddedProxySPI proxySPI) {
        this.proxySPI = proxySPI;
    }

    @Override
    public Node mapNode(VirtualNodeValue value2) {
        if (value2 instanceof NodeProxyWrappingNodeValue) {
            return ((NodeProxyWrappingNodeValue)value2).nodeProxy();
        }
        return new NodeProxy(this.proxySPI, value2.id());
    }

    @Override
    public Relationship mapRelationship(VirtualRelationshipValue value2) {
        if (value2 instanceof RelationshipProxyWrappingValue) {
            return ((RelationshipProxyWrappingValue)value2).relationshipProxy();
        }
        return new RelationshipProxy(this.proxySPI, value2.id());
    }

    @Override
    public Path mapPath(PathValue value2) {
        if (value2 instanceof PathWrappingPathValue) {
            return ((PathWrappingPathValue)value2).path();
        }
        return new CoreAPIPath(value2);
    }

    private <U, V> Iterable<V> asList(final U[] values2, final Function<U, V> mapper) {
        return () -> new Iterator<V>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < values2.length;
            }

            @Override
            public V next() {
                return mapper.apply(values2[this.index++]);
            }
        };
    }

    private <U, V> Iterable<V> asReverseList(final U[] values2, final Function<U, V> mapper) {
        return () -> new Iterator<V>(){
            private int index;
            {
                this.index = values2.length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public V next() {
                return mapper.apply(values2[this.index--]);
            }
        };
    }

    private class CoreAPIPath
    implements Path {
        private final PathValue value;

        CoreAPIPath(PathValue value2) {
            this.value = value2;
        }

        @Override
        public String toString() {
            return Paths.defaultPathToStringWithNotInTransactionFallback(this);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CoreAPIPath) {
                return this.value.equals(((CoreAPIPath)obj).value);
            }
            if (obj instanceof Path) {
                Path other2 = (Path)obj;
                if (this.value.nodes()[0].id() != other2.startNode().getId()) {
                    return false;
                }
                return Iterators.iteratorsEqual(this.relationships().iterator(), other2.relationships().iterator());
            }
            return false;
        }

        @Override
        public Node startNode() {
            return DefaultValueMapper.this.mapNode(this.value.startNode());
        }

        @Override
        public Node endNode() {
            return DefaultValueMapper.this.mapNode(this.value.endNode());
        }

        @Override
        public Relationship lastRelationship() {
            if (this.value.size() == 0) {
                return null;
            }
            return DefaultValueMapper.this.mapRelationship(this.value.lastRelationship());
        }

        @Override
        public Iterable<Relationship> relationships() {
            return DefaultValueMapper.this.asList(this.value.relationships(), DefaultValueMapper.this::mapRelationship);
        }

        @Override
        public Iterable<Relationship> reverseRelationships() {
            return DefaultValueMapper.this.asReverseList(this.value.relationships(), DefaultValueMapper.this::mapRelationship);
        }

        @Override
        public Iterable<Node> nodes() {
            return DefaultValueMapper.this.asList(this.value.nodes(), DefaultValueMapper.this::mapNode);
        }

        @Override
        public Iterable<Node> reverseNodes() {
            return DefaultValueMapper.this.asReverseList(this.value.nodes(), DefaultValueMapper.this::mapNode);
        }

        @Override
        public int length() {
            return this.value.size();
        }

        @Override
        public Iterator<PropertyContainer> iterator() {
            return new Iterator<PropertyContainer>(){
                private final int size;
                private int index;
                private final NodeValue[] nodes;
                private final RelationshipValue[] relationships;
                {
                    this.size = 2 * CoreAPIPath.this.value.size() + 1;
                    this.nodes = CoreAPIPath.this.value.nodes();
                    this.relationships = CoreAPIPath.this.value.relationships();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.size;
                }

                @Override
                public PropertyContainer next() {
                    Entity propertyContainer = (this.index & 1) == 0 ? DefaultValueMapper.this.mapNode(this.nodes[this.index >> 1]) : DefaultValueMapper.this.mapRelationship(this.relationships[this.index >> 1]);
                    ++this.index;
                    return propertyContainer;
                }
            };
        }
    }
}

