/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;

public class PositionAwarePhysicalFlushableChannel
implements FlushablePositionAwareChannel {
    private LogVersionedStoreChannel logVersionedStoreChannel;
    private final PhysicalFlushableChannel channel;

    public PositionAwarePhysicalFlushableChannel(LogVersionedStoreChannel logVersionedStoreChannel) {
        this.logVersionedStoreChannel = logVersionedStoreChannel;
        this.channel = new PhysicalFlushableChannel(logVersionedStoreChannel);
    }

    public PositionAwarePhysicalFlushableChannel(LogVersionedStoreChannel logVersionedStoreChannel, int bufferSize) {
        this.logVersionedStoreChannel = logVersionedStoreChannel;
        this.channel = new PhysicalFlushableChannel(logVersionedStoreChannel, bufferSize);
    }

    @Override
    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(this.logVersionedStoreChannel.getVersion(), this.channel.position());
        return positionMarker;
    }

    @Override
    public Flushable prepareForFlush() throws IOException {
        return this.channel.prepareForFlush();
    }

    @Override
    public FlushableChannel put(byte value2) throws IOException {
        return this.channel.put(value2);
    }

    @Override
    public FlushableChannel putShort(short value2) throws IOException {
        return this.channel.putShort(value2);
    }

    @Override
    public FlushableChannel putInt(int value2) throws IOException {
        return this.channel.putInt(value2);
    }

    @Override
    public FlushableChannel putLong(long value2) throws IOException {
        return this.channel.putLong(value2);
    }

    @Override
    public FlushableChannel putFloat(float value2) throws IOException {
        return this.channel.putFloat(value2);
    }

    @Override
    public FlushableChannel putDouble(double value2) throws IOException {
        return this.channel.putDouble(value2);
    }

    @Override
    public FlushableChannel put(byte[] value2, int length2) throws IOException {
        return this.channel.put(value2, length2);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public void setChannel(LogVersionedStoreChannel channel) {
        this.logVersionedStoreChannel = channel;
        this.channel.setChannel(channel);
    }

    public void setCurrentPosition(LogPosition position2) throws IOException, UnsupportedOperationException {
        this.channel.position(position2.getByteOffset());
    }
}

