/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a Time instant.")
class TimeFunction
extends TemporalFunction<TimeValue> {
    TimeFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTTime, defaultZone);
    }

    @Override
    protected TimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? TimeValue.now(clock, defaultZone) : TimeValue.now(clock, timezone);
    }

    @Override
    protected TimeValue parse(TextValue value2, Supplier<ZoneId> defaultZone) {
        return TimeValue.parse(value2, defaultZone);
    }

    @Override
    protected TimeValue build(MapValue map2, Supplier<ZoneId> defaultZone) {
        return TimeValue.build(map2, defaultZone);
    }

    @Override
    protected TimeValue select(AnyValue from2, Supplier<ZoneId> defaultZone) {
        return TimeValue.select(from2, defaultZone);
    }

    @Override
    protected TimeValue truncate(TemporalUnit unit, TemporalValue input2, MapValue fields, Supplier<ZoneId> defaultZone) {
        return TimeValue.truncate(unit, input2, fields, defaultZone);
    }
}

