/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.impl.coreapi.IndexProvider;
import org.neo4j.kernel.impl.coreapi.ReadOnlyIndexFacade;
import org.neo4j.kernel.impl.coreapi.RelationshipReadOnlyIndexFacade;

public class IndexManagerImpl
implements IndexManager {
    private final Supplier<Transaction> transactionBridge;
    private final IndexProvider provider;
    private final AutoIndexer<Node> nodeAutoIndexer;
    private final RelationshipAutoIndexer relAutoIndexer;

    public IndexManagerImpl(Supplier<Transaction> bridge2, IndexProvider provider, AutoIndexer<Node> nodeAutoIndexer, RelationshipAutoIndexer relAutoIndexer) {
        this.transactionBridge = bridge2;
        this.provider = provider;
        this.nodeAutoIndexer = nodeAutoIndexer;
        this.relAutoIndexer = relAutoIndexer;
    }

    @Override
    public boolean existsForNodes(String indexName) {
        try {
            this.transactionBridge.get().indexRead().nodeExplicitIndexGetConfiguration(indexName);
            return true;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            return false;
        }
    }

    @Override
    public Index<Node> forNodes(String indexName) {
        return this.forNodes(indexName, null);
    }

    @Override
    public Index<Node> forNodes(String indexName, Map<String, String> customConfiguration) {
        Index<Node> toReturn = this.provider.getOrCreateNodeIndex(indexName, customConfiguration);
        if ("node_auto_index".equals(indexName)) {
            return new ReadOnlyIndexFacade<Node>(toReturn);
        }
        return toReturn;
    }

    @Override
    public String[] nodeIndexNames() {
        return this.transactionBridge.get().indexRead().nodeExplicitIndexesGetAll();
    }

    @Override
    public boolean existsForRelationships(String indexName) {
        try {
            this.transactionBridge.get().indexRead().relationshipExplicitIndexGetConfiguration(indexName);
            return true;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            return false;
        }
    }

    @Override
    public RelationshipIndex forRelationships(String indexName) {
        return this.forRelationships(indexName, null);
    }

    @Override
    public RelationshipIndex forRelationships(String indexName, Map<String, String> customConfiguration) {
        RelationshipIndex toReturn = this.provider.getOrCreateRelationshipIndex(indexName, customConfiguration);
        if ("relationship_auto_index".equals(indexName)) {
            return new RelationshipReadOnlyIndexFacade(toReturn);
        }
        return toReturn;
    }

    @Override
    public String[] relationshipIndexNames() {
        return this.transactionBridge.get().indexRead().relationshipExplicitIndexesGetAll();
    }

    @Override
    public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
        try {
            Transaction transaction = this.transactionBridge.get();
            if (index.getEntityType().equals(Node.class)) {
                return transaction.indexRead().nodeExplicitIndexGetConfiguration(index.getName());
            }
            if (index.getEntityType().equals(Relationship.class)) {
                return transaction.indexRead().relationshipExplicitIndexGetConfiguration(index.getName());
            }
            throw new IllegalArgumentException("Unknown entity type " + index.getEntityType().getSimpleName());
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException("No node index '" + index.getName() + "' found");
        }
    }

    @Override
    public String setConfiguration(Index<? extends PropertyContainer> index, String key, String value2) {
        try {
            Transaction transaction = this.transactionBridge.get();
            if (index.getEntityType().equals(Node.class)) {
                return transaction.indexWrite().nodeExplicitIndexSetConfiguration(index.getName(), key, value2);
            }
            if (index.getEntityType().equals(Relationship.class)) {
                return transaction.indexWrite().relationshipExplicitIndexSetConfiguration(index.getName(), key, value2);
            }
            throw new IllegalArgumentException("Unknown entity type " + index.getEntityType().getSimpleName());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public String removeConfiguration(Index<? extends PropertyContainer> index, String key) {
        try {
            Transaction transaction = this.transactionBridge.get();
            if (index.getEntityType().equals(Node.class)) {
                return transaction.indexWrite().nodeExplicitIndexRemoveConfiguration(index.getName(), key);
            }
            if (index.getEntityType().equals(Relationship.class)) {
                return transaction.indexWrite().relationshipExplicitIndexRemoveConfiguration(index.getName(), key);
            }
            throw new IllegalArgumentException("Unknown entity type " + index.getEntityType().getSimpleName());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public AutoIndexer<Node> getNodeAutoIndexer() {
        return this.nodeAutoIndexer;
    }

    @Override
    public RelationshipAutoIndexer getRelationshipAutoIndexer() {
        return this.relAutoIndexer;
    }
}

