/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.UnsafeDirectByteBufferAllocator;
import org.neo4j.memory.GlobalMemoryTracker;
import org.neo4j.memory.ThreadSafePeakMemoryAllocationTracker;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.util.concurrent.Runnables;

public class IndexPopulationJob
implements Runnable {
    private final IndexingService.Monitor monitor;
    private final boolean verifyBeforeFlipping;
    private final ByteBufferFactory bufferFactory;
    private final ThreadSafePeakMemoryAllocationTracker memoryAllocationTracker;
    private final MultipleIndexPopulator multiPopulator;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private volatile StoreScan<IndexPopulationFailedKernelException> storeScan;
    private volatile boolean cancelled;

    public IndexPopulationJob(MultipleIndexPopulator multiPopulator, IndexingService.Monitor monitor, boolean verifyBeforeFlipping) {
        this.multiPopulator = multiPopulator;
        this.monitor = monitor;
        this.verifyBeforeFlipping = verifyBeforeFlipping;
        this.memoryAllocationTracker = new ThreadSafePeakMemoryAllocationTracker(GlobalMemoryTracker.INSTANCE);
        this.bufferFactory = new ByteBufferFactory(() -> new UnsafeDirectByteBufferAllocator(this.memoryAllocationTracker), BlockBasedIndexPopulator.parseBlockSize());
    }

    MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator populator, CapableIndexDescriptor capableIndexDescriptor, String indexUserDescription, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory) {
        assert (this.storeScan == null) : "Population have already started, too late to add populators at this point";
        return this.multiPopulator.addPopulator(populator, capableIndexDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String oldThreadName;
        block9: {
            block8: {
                oldThreadName = Thread.currentThread().getName();
                try {
                    if (this.multiPopulator.hasPopulators()) break block8;
                }
                catch (Throwable throwable) {
                    Runnable[] runnableArray = new Runnable[5];
                    runnableArray[0] = () -> this.multiPopulator.close(true);
                    runnableArray[1] = () -> this.monitor.populationJobCompleted(this.memoryAllocationTracker.peakMemoryUsage());
                    runnableArray[2] = this.bufferFactory::close;
                    runnableArray[3] = this.doneSignal::countDown;
                    runnableArray[4] = () -> Thread.currentThread().setName(oldThreadName);
                    Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])runnableArray);
                    throw throwable;
                }
                Runnable[] runnableArray = new Runnable[5];
                runnableArray[0] = () -> this.multiPopulator.close(true);
                runnableArray[1] = () -> this.monitor.populationJobCompleted(this.memoryAllocationTracker.peakMemoryUsage());
                runnableArray[2] = this.bufferFactory::close;
                runnableArray[3] = this.doneSignal::countDown;
                runnableArray[4] = () -> Thread.currentThread().setName(oldThreadName);
                Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])runnableArray);
                return;
            }
            if (this.storeScan != null) {
                throw new IllegalStateException("Population already started.");
            }
            Thread.currentThread().setName("Index populator");
            this.multiPopulator.create();
            this.multiPopulator.resetIndexCounts();
            this.monitor.indexPopulationScanStarting();
            this.indexAllEntities();
            this.monitor.indexPopulationScanComplete();
            if (!this.cancelled) break block9;
            this.multiPopulator.cancel();
            Runnable[] runnableArray = new Runnable[5];
            runnableArray[0] = () -> this.multiPopulator.close(true);
            runnableArray[1] = () -> this.monitor.populationJobCompleted(this.memoryAllocationTracker.peakMemoryUsage());
            runnableArray[2] = this.bufferFactory::close;
            runnableArray[3] = this.doneSignal::countDown;
            runnableArray[4] = () -> Thread.currentThread().setName(oldThreadName);
            Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])runnableArray);
            return;
        }
        try {
            this.multiPopulator.flipAfterPopulation(this.verifyBeforeFlipping);
        }
        catch (Throwable t) {
            this.multiPopulator.fail(t);
        }
        Runnable[] runnableArray = new Runnable[5];
        runnableArray[0] = () -> this.multiPopulator.close(true);
        runnableArray[1] = () -> this.monitor.populationJobCompleted(this.memoryAllocationTracker.peakMemoryUsage());
        runnableArray[2] = this.bufferFactory::close;
        runnableArray[3] = this.doneSignal::countDown;
        runnableArray[4] = () -> Thread.currentThread().setName(oldThreadName);
        Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])runnableArray);
    }

    private void indexAllEntities() throws IndexPopulationFailedKernelException {
        this.storeScan = this.multiPopulator.indexAllEntities();
        this.storeScan.run();
    }

    PopulationProgress getPopulationProgress(MultipleIndexPopulator.IndexPopulation indexPopulation) {
        if (this.storeScan == null) {
            return PopulationProgress.NONE;
        }
        PopulationProgress storeScanProgress = this.storeScan.getProgress();
        return indexPopulation.progress(storeScanProgress);
    }

    public Future<Void> cancel() {
        if (this.storeScan != null) {
            this.cancelled = true;
            this.storeScan.stop();
            this.monitor.populationCancelled();
        }
        return FutureAdapter.latchGuardedValue(Suppliers.singleton(null), this.doneSignal, "Index population job cancel");
    }

    void cancelPopulation(MultipleIndexPopulator.IndexPopulation population) {
        this.multiPopulator.cancelIndexPopulation(population);
    }

    void dropPopulation(MultipleIndexPopulator.IndexPopulation population) {
        this.multiPopulator.dropIndexPopulation(population);
    }

    public void update(IndexEntryUpdate<?> update2) {
        this.multiPopulator.queueUpdate(update2);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[populator:" + this.multiPopulator + "]";
    }

    public boolean awaitCompletion(long time, TimeUnit unit) throws InterruptedException {
        if (time == 0L) {
            this.doneSignal.await();
            return false;
        }
        boolean completed = this.doneSignal.await(time, unit);
        return !completed;
    }

    public ByteBufferFactory bufferFactory() {
        return this.bufferFactory;
    }
}

