/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensionFailureStrategy;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependenciesProxy;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public abstract class AbstractKernelExtensions
extends DependencyResolver.Adapter
implements Lifecycle {
    private final KernelContext kernelContext;
    private final List<KernelExtensionFactory<?>> kernelExtensionFactories;
    private final Dependencies dependencies;
    private final LifeSupport life = new LifeSupport();
    private final KernelExtensionFailureStrategy kernelExtensionFailureStrategy;

    AbstractKernelExtensions(KernelContext kernelContext, Iterable<KernelExtensionFactory<?>> kernelExtensionFactories, Dependencies dependencies2, KernelExtensionFailureStrategy kernelExtensionFailureStrategy, ExtensionType extensionType) {
        this.kernelContext = kernelContext;
        this.kernelExtensionFailureStrategy = kernelExtensionFailureStrategy;
        this.kernelExtensionFactories = Iterables.stream(kernelExtensionFactories).filter(e -> e.getExtensionType() == extensionType).collect(Collectors.toList());
        this.dependencies = dependencies2;
    }

    @Override
    public void init() {
        for (KernelExtensionFactory<?> kernelExtensionFactory : this.kernelExtensionFactories) {
            try {
                Object kernelExtensionDependencies = this.getKernelExtensionDependencies(kernelExtensionFactory);
                Lifecycle dependency = AbstractKernelExtensions.newInstance(this.kernelContext, kernelExtensionFactory, kernelExtensionDependencies);
                Objects.requireNonNull(dependency, kernelExtensionFactory.toString() + " returned a null KernelExtension");
                this.life.add(this.dependencies.satisfyDependency(dependency));
            }
            catch (UnsatisfiedDependencyException exception) {
                this.kernelExtensionFailureStrategy.handle(kernelExtensionFactory, exception);
            }
            catch (Throwable throwable) {
                this.kernelExtensionFailureStrategy.handle(kernelExtensionFactory, throwable);
            }
        }
        this.life.init();
    }

    @Override
    public void start() {
        this.life.start();
    }

    @Override
    public void stop() {
        this.life.stop();
    }

    @Override
    public void shutdown() {
        this.life.shutdown();
    }

    @Override
    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
        Iterable<T> typeDependencies = this.resolveTypeDependencies(type);
        return selector.select(type, typeDependencies);
    }

    @Override
    public <T> Iterable<? extends T> resolveTypeDependencies(Class<T> type) throws IllegalArgumentException {
        return this.life.getLifecycleInstances().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    private Object getKernelExtensionDependencies(KernelExtensionFactory<?> factory) {
        Class configurationClass = (Class)((ParameterizedType)factory.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return DependenciesProxy.dependencies(this.dependencies, configurationClass);
    }

    private static <T> Lifecycle newInstance(KernelContext kernelContext, KernelExtensionFactory<T> factory, Object dependencies2) {
        return factory.newInstance(kernelContext, dependencies2);
    }
}

