/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.ScopeAwareSetting;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.Numbers;
import org.neo4j.helpers.SocketAddressParser;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.helpers.collection.CollectorsUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.values.storable.DateTimeValue;

public class Settings {
    private static final String MATCHES_PATTERN_MESSAGE = "matches the pattern `%s`";
    public static final String NO_DEFAULT = null;
    public static final String EMPTY = "";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String DEFAULT = "default";
    public static final String SEPARATOR = ",";
    private static final String SIZE_FORMAT = "\\d+[kmgKMG]?";
    private static final String SIZE_UNITS = Arrays.toString("\\d+[kmgKMG]?".substring("\\d+[kmgKMG]?".indexOf(91) + 1, "\\d+[kmgKMG]?".indexOf(93)).toCharArray()).replace("[", "").replace("]", "");
    public static final String ANY = ".+";
    public static final Function<String, Integer> INTEGER = new Function<String, Integer>(){

        @Override
        public Integer apply(String value2) {
            try {
                return Integer.valueOf(value2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid integer value");
            }
        }

        public String toString() {
            return "an integer";
        }
    };
    public static final Function<String, Long> LONG = new Function<String, Long>(){

        @Override
        public Long apply(String value2) {
            try {
                return Long.valueOf(value2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid long value");
            }
        }

        public String toString() {
            return "a long";
        }
    };
    public static final Function<String, Boolean> BOOLEAN = new Function<String, Boolean>(){

        @Override
        public Boolean apply(String value2) {
            if (value2.equalsIgnoreCase(Settings.TRUE)) {
                return Boolean.TRUE;
            }
            if (value2.equalsIgnoreCase(Settings.FALSE)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("must be 'true' or 'false'");
        }

        public String toString() {
            return "a boolean";
        }
    };
    public static final Function<String, Float> FLOAT = new Function<String, Float>(){

        @Override
        public Float apply(String value2) {
            try {
                return Float.valueOf(value2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid float value");
            }
        }

        public String toString() {
            return "a float";
        }
    };
    public static final Function<String, Double> DOUBLE = new Function<String, Double>(){

        @Override
        public Double apply(String value2) {
            try {
                return Double.valueOf(value2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid double value");
            }
        }

        public String toString() {
            return "a double";
        }
    };
    public static final Function<String, String> STRING = new Function<String, String>(){

        @Override
        public String apply(String value2) {
            return value2.trim();
        }

        public String toString() {
            return "a string";
        }
    };
    public static final Function<String, List<String>> STRING_LIST = Settings.list(",", STRING);
    public static final Function<String, HostnamePort> HOSTNAME_PORT = new Function<String, HostnamePort>(){

        @Override
        public HostnamePort apply(String value2) {
            return new HostnamePort(value2);
        }

        public String toString() {
            return "a hostname and port";
        }
    };
    public static final Function<String, Duration> DURATION = new Function<String, Duration>(){

        @Override
        public Duration apply(String value2) {
            return Duration.ofMillis(TimeUtil.parseTimeMillis.apply(value2));
        }

        public String toString() {
            return "a duration (Valid units are: 'ms', 's', 'm' and 'h'; default unit is 's')";
        }
    };
    public static final Function<String, ZoneId> TIMEZONE = new Function<String, ZoneId>(){

        @Override
        public ZoneId apply(String value2) {
            return DateTimeValue.parseZoneOffsetOrZoneName(value2);
        }

        public String toString() {
            return "a string describing a timezone, either described by offset (e.g. '+02:00') or by name (e.g. 'Europe/Stockholm')";
        }
    };
    public static final Function<String, ListenSocketAddress> LISTEN_SOCKET_ADDRESS = new Function<String, ListenSocketAddress>(){

        @Override
        public ListenSocketAddress apply(String value2) {
            return SocketAddressParser.socketAddress(value2, ListenSocketAddress::new);
        }

        public String toString() {
            return "a listen socket address";
        }
    };
    public static final Function<String, AdvertisedSocketAddress> ADVERTISED_SOCKET_ADDRESS = new Function<String, AdvertisedSocketAddress>(){

        @Override
        public AdvertisedSocketAddress apply(String value2) {
            return SocketAddressParser.socketAddress(value2, AdvertisedSocketAddress::new);
        }

        public String toString() {
            return "an advertised socket address";
        }
    };
    public static final Function<String, Long> BYTES = new Function<String, Long>(){

        @Override
        public Long apply(String value2) {
            long bytes2;
            try {
                bytes2 = ByteUnit.parse((String)value2);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("%s is not a valid size, must be e.g. 10, 5K, 1M, 11G", value2));
            }
            if (bytes2 < 0L) {
                throw new IllegalArgumentException(value2 + " is not a valid number of bytes. Must be positive or zero.");
            }
            return bytes2;
        }

        public String toString() {
            return "a byte size (valid multipliers are `" + SIZE_UNITS.replace(", ", "`, `") + "`)";
        }
    };
    public static final Function<String, URI> URI = new Function<String, URI>(){

        @Override
        public URI apply(String value2) {
            try {
                return new URI(value2);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("not a valid URI");
            }
        }

        public String toString() {
            return "a URI";
        }
    };
    public static final Function<String, URI> NORMALIZED_RELATIVE_URI = new Function<String, URI>(){

        @Override
        public URI apply(String value2) {
            try {
                String normalizedUri = new URI(value2).normalize().getPath();
                if (normalizedUri.endsWith("/")) {
                    normalizedUri = normalizedUri.substring(0, normalizedUri.length() - 1);
                }
                return new URI(normalizedUri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("not a valid URI");
            }
        }

        public String toString() {
            return "a URI";
        }
    };
    public static final Function<String, File> PATH = new Function<String, File>(){

        @Override
        public File apply(String setting) {
            File file = new File(FileUtils.fixSeparatorsInPath((String)setting));
            if (!file.isAbsolute()) {
                throw new IllegalArgumentException("Paths must be absolute. Got " + file);
            }
            return file;
        }

        public String toString() {
            return "a path";
        }
    };
    public static final BiFunction<List<String>, Function<String, String>, List<String>> nonEmptyList = new BiFunction<List<String>, Function<String, String>, List<String>>(){

        @Override
        public List<String> apply(List<String> values2, Function<String, String> settings) {
            if (values2.isEmpty()) {
                throw new IllegalArgumentException("setting must not be empty");
            }
            return values2;
        }

        public String toString() {
            return "non-empty list";
        }
    };
    public static final BiFunction<Integer, Function<String, String>, Integer> port = Settings.illegalValueMessage("must be a valid port number", Settings.range(0, 65535));

    @Nonnull
    public static <T> Setting<T> setting(@Nonnull String name, @Nonnull Function<String, T> parser, @Nullable String defaultValue) {
        return new SettingBuilder(name, parser, defaultValue).build();
    }

    @Nonnull
    public static <T> SettingBuilder<T> buildSetting(@Nonnull String name, @Nonnull Function<String, T> parser) {
        return Settings.buildSetting(name, parser, NO_DEFAULT);
    }

    @Nonnull
    public static <T> SettingBuilder<T> buildSetting(@Nonnull String name, @Nonnull Function<String, T> parser, @Nullable String defaultValue) {
        return new SettingBuilder(name, parser, defaultValue);
    }

    public static BiFunction<String, Function<String, String>, String> determineDefaultLookup(String defaultValue, BiFunction<String, Function<String, String>, String> valueLookup) {
        BiFunction<String, Function<String, String>, String> defaultLookup = defaultValue != null ? Settings.withDefault(defaultValue, valueLookup) : (n, from2) -> null;
        return defaultLookup;
    }

    public static <OUT, IN1, IN2> Setting<OUT> derivedSetting(final String name, final Setting<IN1> in1, final Setting<IN2> in2, final BiFunction<IN1, IN2, OUT> derivation, final Function<String, OUT> overrideConverter) {
        return new ScopeAwareSetting<OUT>(){

            @Override
            protected String provideName() {
                return name;
            }

            @Override
            public String getDefaultValue() {
                return NO_DEFAULT;
            }

            @Override
            public OUT from(Configuration config) {
                return config.get(this);
            }

            @Override
            public OUT apply(Function<String, String> config) {
                String override = config.apply(this.name());
                if (override != null) {
                    return overrideConverter.apply(override);
                }
                return derivation.apply(in1.apply(config), in2.apply(config));
            }

            @Override
            public String valueDescription() {
                return in1.valueDescription();
            }
        };
    }

    public static <OUT, IN1> Setting<OUT> derivedSetting(final String name, final Setting<IN1> in1, final Function<IN1, OUT> derivation, final Function<String, OUT> overrideConverter) {
        return new ScopeAwareSetting<OUT>(){

            @Override
            protected String provideName() {
                return name;
            }

            @Override
            public String getDefaultValue() {
                return NO_DEFAULT;
            }

            @Override
            public OUT from(Configuration config) {
                return config.get(this);
            }

            @Override
            public OUT apply(Function<String, String> config) {
                String override = config.apply(this.name());
                if (override != null) {
                    return overrideConverter.apply(override);
                }
                return derivation.apply(in1.apply(config));
            }

            @Override
            public String valueDescription() {
                return in1.valueDescription();
            }
        };
    }

    public static Setting<File> pathSetting(String name, String defaultValue) {
        return new FileSetting(name, defaultValue);
    }

    public static Setting<File> pathSetting(String name, String defaultValue, Setting<File> relativeRoot) {
        return new FileSetting(name, defaultValue, relativeRoot);
    }

    private static <T> BiFunction<String, Function<String, String>, String> inheritedValue(BiFunction<String, Function<String, String>, String> lookup2, Setting<T> inheritedSetting) {
        return (name, settings) -> {
            String value2 = (String)lookup2.apply((String)name, (Function<String, String>)settings);
            if (value2 == null) {
                value2 = ((SettingHelper)inheritedSetting).lookup((Function<String, String>)settings);
            }
            return value2;
        };
    }

    private static <T> BiFunction<String, Function<String, String>, String> inheritedDefault(BiFunction<String, Function<String, String>, String> lookup2, Setting<T> inheritedSetting) {
        return (name, settings) -> {
            String value2 = (String)lookup2.apply((String)name, (Function<String, String>)settings);
            if (value2 == null) {
                value2 = ((SettingHelper)inheritedSetting).defaultLookup((Function<String, String>)settings);
            }
            return value2;
        };
    }

    public static BaseSetting<ListenSocketAddress> listenAddress(final String name, final int defaultPort) {
        return new ScopeAwareSetting<ListenSocketAddress>(){

            @Override
            protected String provideName() {
                return name;
            }

            @Override
            public String getDefaultValue() {
                return GraphDatabaseSettings.default_listen_address.getDefaultValue() + ":" + defaultPort;
            }

            @Override
            public ListenSocketAddress from(Configuration config) {
                return config.get(this);
            }

            @Override
            public ListenSocketAddress apply(Function<String, String> config) {
                String name2 = this.name();
                String value2 = config.apply(name2);
                String hostname = (String)GraphDatabaseSettings.default_listen_address.apply((String)((Object)config));
                return SocketAddressParser.deriveSocketAddress(name2, value2, hostname, defaultPort, ListenSocketAddress::new);
            }

            @Override
            public String valueDescription() {
                return LISTEN_SOCKET_ADDRESS.toString();
            }
        };
    }

    public static BaseSetting<AdvertisedSocketAddress> advertisedAddress(final String name, final Setting<ListenSocketAddress> listenAddressSetting) {
        return new ScopeAwareSetting<AdvertisedSocketAddress>(){

            @Override
            protected String provideName() {
                return name;
            }

            @Override
            public String getDefaultValue() {
                return GraphDatabaseSettings.default_advertised_address.getDefaultValue() + ":" + LISTEN_SOCKET_ADDRESS.apply(listenAddressSetting.getDefaultValue()).socketAddress().getPort();
            }

            @Override
            public AdvertisedSocketAddress from(Configuration config) {
                return config.get(this);
            }

            @Override
            public AdvertisedSocketAddress apply(Function<String, String> config) {
                ListenSocketAddress listenSocketAddress = (ListenSocketAddress)listenAddressSetting.apply(config);
                String hostname = (String)GraphDatabaseSettings.default_advertised_address.apply((String)((Object)config));
                int port = listenSocketAddress.socketAddress().getPort();
                String name2 = this.name();
                String value2 = config.apply(name2);
                return SocketAddressParser.deriveSocketAddress(name2, value2, hostname, port, AdvertisedSocketAddress::new);
            }

            @Override
            public void withScope(Function<String, String> scopingRule) {
                super.withScope(scopingRule);
                listenAddressSetting.withScope(scopingRule);
            }

            @Override
            public String valueDescription() {
                return ADVERTISED_SOCKET_ADDRESS.toString();
            }
        };
    }

    public static <T extends Enum<T>> Function<String, T> optionsObeyCase(Class<T> enumClass) {
        return Settings.options(EnumSet.allOf(enumClass), false);
    }

    public static <T extends Enum<T>> Function<String, T> optionsIgnoreCase(Class<T> enumClass) {
        return Settings.options(EnumSet.allOf(enumClass), true);
    }

    public static <T> Function<String, T> optionsObeyCase(T ... optionValues) {
        return Settings.options(Iterables.iterable((Object[])optionValues), false);
    }

    public static <T> Function<String, T> optionsIgnoreCase(T ... optionValues) {
        return Settings.options(Iterables.iterable((Object[])optionValues), true);
    }

    public static <T> Function<String, T> options(final Iterable<T> optionValues, final boolean ignoreCase2) {
        return new Function<String, T>(){

            @Override
            public T apply(String value2) {
                for (Object optionValue : optionValues) {
                    String allowedValue = optionValue.toString();
                    if (!allowedValue.equals(value2) && (!ignoreCase2 || !allowedValue.equalsIgnoreCase(value2))) continue;
                    return optionValue;
                }
                String possibleValues = Iterables.asList((Iterable)optionValues).toString();
                throw new IllegalArgumentException("must be one of " + possibleValues + " case " + (ignoreCase2 ? "insensitive" : "sensitive"));
            }

            public String toString() {
                return Settings.describeOneOf(optionValues);
            }
        };
    }

    @Nonnull
    public static String describeOneOf(@Nonnull Iterable optionValues) {
        StringBuilder builder = new StringBuilder();
        builder.append("one of `");
        String comma = EMPTY;
        for (Object optionValue : optionValues) {
            builder.append(comma).append(optionValue);
            comma = "`, `";
        }
        builder.append('`');
        return builder.toString();
    }

    public static <T> Function<String, List<T>> list(final String separator, final Function<String, T> itemParser) {
        return new Function<String, List<T>>(){

            @Override
            public List<T> apply(String value2) {
                String[] parts;
                ArrayList list2 = new ArrayList();
                for (String part : parts = value2.split(separator)) {
                    if (!StringUtils.isNotEmpty(part = part.trim())) continue;
                    list2.add(itemParser.apply(part));
                }
                return list2;
            }

            public String toString() {
                return "a list separated by \"" + separator + "\" where items are " + itemParser;
            }
        };
    }

    public static BiFunction<String, Function<String, String>, String> matches(final String regex) {
        final Pattern pattern = Pattern.compile(regex);
        return new BiFunction<String, Function<String, String>, String>(){

            @Override
            public String apply(String value2, Function<String, String> settings) {
                if (!pattern.matcher(value2).matches()) {
                    throw new IllegalArgumentException("value does not match expression:" + regex);
                }
                return value2;
            }

            public String toString() {
                return String.format(Settings.MATCHES_PATTERN_MESSAGE, regex);
            }
        };
    }

    public static BiFunction<List<String>, Function<String, String>, List<String>> matchesAny(final String regex) {
        final Pattern pattern = Pattern.compile(regex);
        return new BiFunction<List<String>, Function<String, String>, List<String>>(){

            @Override
            public List<String> apply(List<String> values2, Function<String, String> settings) {
                for (String value2 : values2) {
                    if (pattern.matcher(value2).matches()) continue;
                    throw new IllegalArgumentException("value does not match expression:" + regex);
                }
                return values2;
            }

            public String toString() {
                return String.format(Settings.MATCHES_PATTERN_MESSAGE, regex);
            }
        };
    }

    public static BiFunction<String, Function<String, String>, String> except(final String ... forbiddenValues) {
        return new BiFunction<String, Function<String, String>, String>(){

            @Override
            public String apply(String value2, Function<String, String> stringStringFunction) {
                if (StringUtils.isNotBlank(value2) && ArrayUtils.contains(forbiddenValues, value2)) {
                    throw new IllegalArgumentException(String.format("not allowed value is: %s", value2));
                }
                return value2;
            }

            public String toString() {
                if (forbiddenValues.length > 1) {
                    return String.format("is none of %s", Arrays.toString(forbiddenValues));
                }
                if (forbiddenValues.length == 1) {
                    return String.format("is not `%s`", forbiddenValues[0]);
                }
                return Settings.EMPTY;
            }
        };
    }

    public static BiFunction<Long, Function<String, String>, Long> powerOf2() {
        return new BiFunction<Long, Function<String, String>, Long>(){

            @Override
            public Long apply(Long value2, Function<String, String> settings) {
                if (value2 != null && !Numbers.isPowerOfTwo(value2)) {
                    throw new IllegalArgumentException("only power of 2 values allowed");
                }
                return value2;
            }

            public String toString() {
                return "is power of 2";
            }
        };
    }

    public static <T extends Comparable<T>> BiFunction<T, Function<String, String>, T> min(final T min2) {
        return new BiFunction<T, Function<String, String>, T>(){

            @Override
            public T apply(T value2, Function<String, String> settings) {
                if (value2 != null && value2.compareTo((Comparable)min2) < 0) {
                    throw new IllegalArgumentException(String.format("minimum allowed value is: %s", min2));
                }
                return value2;
            }

            public String toString() {
                return "is minimum `" + min2 + "`";
            }
        };
    }

    public static <T extends Comparable<T>> BiFunction<T, Function<String, String>, T> max(final T max2) {
        return new BiFunction<T, Function<String, String>, T>(){

            @Override
            public T apply(T value2, Function<String, String> settings) {
                if (value2 != null && value2.compareTo((Comparable)max2) > 0) {
                    throw new IllegalArgumentException(String.format("maximum allowed value is: %s", max2));
                }
                return value2;
            }

            public String toString() {
                return "is maximum `" + max2 + "`";
            }
        };
    }

    public static <T extends Comparable<T>> BiFunction<T, Function<String, String>, T> range(final T min2, final T max2) {
        return new BiFunction<T, Function<String, String>, T>(){

            @Override
            public T apply(T from1, Function<String, String> from2) {
                return Settings.min(min2).apply(Settings.max(max2).apply((Comparable)from1, from2), from2);
            }

            public String toString() {
                return String.format("is in the range `%s` to `%s`", min2, max2);
            }
        };
    }

    public static <T> BiFunction<T, Function<String, String>, T> illegalValueMessage(final String message, final BiFunction<T, Function<String, String>, T> valueFunction) {
        return new BiFunction<T, Function<String, String>, T>(){

            @Override
            public T apply(T from1, Function<String, String> from2) {
                try {
                    return valueFunction.apply(from1, from2);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(message);
                }
            }

            public String toString() {
                String description = message;
                if (valueFunction != null && !String.format(Settings.MATCHES_PATTERN_MESSAGE, Settings.ANY).equals(valueFunction.toString())) {
                    description = description + " (" + valueFunction + ")";
                }
                return description;
            }
        };
    }

    public static long parseLongWithUnit(String numberWithPotentialUnit) {
        int firstNonDigitIndex = Settings.findFirstNonDigit(numberWithPotentialUnit);
        String number = numberWithPotentialUnit.substring(0, firstNonDigitIndex);
        long multiplier = 1L;
        if (firstNonDigitIndex < numberWithPotentialUnit.length()) {
            String unit = numberWithPotentialUnit.substring(firstNonDigitIndex);
            if (unit.equalsIgnoreCase("k")) {
                multiplier = 1024L;
            } else if (unit.equalsIgnoreCase("m")) {
                multiplier = 0x100000L;
            } else if (unit.equalsIgnoreCase("g")) {
                multiplier = 0x40000000L;
            } else {
                throw new IllegalArgumentException("Illegal unit '" + unit + "' for number '" + numberWithPotentialUnit + "'");
            }
        }
        return Long.parseLong(number) * multiplier;
    }

    private static int findFirstNonDigit(String numberWithPotentialUnit) {
        int firstNonDigitIndex = numberWithPotentialUnit.length();
        for (int i = 0; i < numberWithPotentialUnit.length(); ++i) {
            if (Character.isDigit(numberWithPotentialUnit.charAt(i))) continue;
            firstNonDigitIndex = i;
            break;
        }
        return firstNonDigitIndex;
    }

    private static BiFunction<String, Function<String, String>, String> named() {
        return (name, settings) -> (String)settings.apply(name);
    }

    private static BiFunction<String, Function<String, String>, String> withDefault(String defaultValue, BiFunction<String, Function<String, String>, String> lookup2) {
        return (name, settings) -> {
            String value2 = (String)lookup2.apply((String)name, (Function<String, String>)settings);
            if (value2 == null) {
                return defaultValue;
            }
            return value2;
        };
    }

    public static <T> Setting<T> legacyFallback(final Setting<T> fallbackSetting, final Setting<T> newSetting) {
        return new Setting<T>(){

            @Override
            public String name() {
                return newSetting.name();
            }

            @Override
            public String getDefaultValue() {
                return newSetting.getDefaultValue();
            }

            @Override
            public T from(Configuration config) {
                return newSetting.from(config);
            }

            @Override
            public T apply(Function<String, String> config) {
                String newValue = config.apply(newSetting.name());
                return newValue == null ? fallbackSetting.apply(config) : newSetting.apply(config);
            }

            @Override
            public void withScope(Function<String, String> scopingRule) {
                newSetting.withScope(scopingRule);
            }

            @Override
            public String valueDescription() {
                return newSetting.valueDescription();
            }

            @Override
            public Optional<String> description() {
                return newSetting.description();
            }

            @Override
            public boolean dynamic() {
                return newSetting.dynamic();
            }

            @Override
            public boolean deprecated() {
                return newSetting.deprecated();
            }

            @Override
            public Optional<String> replacement() {
                return newSetting.replacement();
            }

            @Override
            public boolean internal() {
                return newSetting.internal();
            }

            @Override
            public boolean secret() {
                return newSetting.secret();
            }

            @Override
            public Optional<String> documentedDefaultValue() {
                return newSetting.documentedDefaultValue();
            }
        };
    }

    private Settings() {
        throw new AssertionError();
    }

    public static BaseSetting<String> prefixSetting(String name, Function<String, String> parser, String defaultValue) {
        BiFunction<String, Function<String, String>, String> valueLookup = (n, settings) -> (String)settings.apply(n);
        BiFunction<String, Function<String, String>, String> defaultLookup = Settings.determineDefaultLookup(defaultValue, valueLookup);
        return new DefaultSetting<String>(name, parser, valueLookup, defaultLookup, Collections.emptyList()){

            @Override
            public Map<String, String> validate(Map<String, String> rawConfig, Consumer<String> warningConsumer) throws InvalidSettingException {
                try {
                    this.apply(rawConfig::get);
                    return (Map)rawConfig.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(this.name())).collect(CollectorsUtil.entriesToMap());
                }
                catch (RuntimeException e) {
                    throw new InvalidSettingException(e.getMessage(), e);
                }
            }
        };
    }

    private static class FileSetting
    extends ScopeAwareSetting<File> {
        private final String name;
        private final String defaultValue;
        private final Setting<File> relativeRoot;

        FileSetting(String name, String defaultValue) {
            this(name, defaultValue, GraphDatabaseSettings.neo4j_home);
        }

        FileSetting(String name, String defaultValue, Setting<File> relativeRoot) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.relativeRoot = relativeRoot;
        }

        @Override
        protected String provideName() {
            return this.name;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public File from(Configuration config) {
            return config.get(this);
        }

        @Override
        public File apply(Function<String, String> config) {
            String value2 = config.apply(this.name());
            if (value2 == null) {
                value2 = this.defaultValue;
            }
            if (value2 == null) {
                return null;
            }
            String setting = FileUtils.fixSeparatorsInPath((String)value2);
            File settingFile = new File(setting);
            if (settingFile.isAbsolute()) {
                return settingFile;
            }
            return new File((File)this.relativeRoot.apply((File)((Object)config)), setting);
        }

        @Override
        public String valueDescription() {
            return "A filesystem path; relative paths are resolved against the root, _<" + this.relativeRoot.name() + ">_";
        }
    }

    public static class DefaultSetting<T>
    extends ScopeAwareSetting<T>
    implements SettingHelper<T> {
        private final String name;
        private final Function<String, T> parser;
        private final BiFunction<String, Function<String, String>, String> valueLookup;
        private final BiFunction<String, Function<String, String>, String> defaultLookup;
        private final List<BiFunction<T, Function<String, String>, T>> valueConverters;

        protected DefaultSetting(String name, Function<String, T> parser, BiFunction<String, Function<String, String>, String> valueLookup, BiFunction<String, Function<String, String>, String> defaultLookup, List<BiFunction<T, Function<String, String>, T>> valueConverters) {
            this.name = name;
            this.parser = parser;
            this.valueLookup = valueLookup;
            this.defaultLookup = defaultLookup;
            this.valueConverters = valueConverters;
        }

        @Override
        protected String provideName() {
            return this.name;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultLookup(from2 -> null);
        }

        @Override
        public T from(Configuration config) {
            return config.get(this);
        }

        @Override
        public Optional<Function<String, T>> getParser() {
            return Optional.of(this.parser);
        }

        @Override
        public String lookup(Function<String, String> settings) {
            return this.valueLookup.apply(this.name(), settings);
        }

        @Override
        public String defaultLookup(Function<String, String> settings) {
            return this.defaultLookup.apply(this.name(), settings);
        }

        @Override
        public T apply(Function<String, String> settings) {
            T result2;
            String value2 = this.lookup(settings);
            if (value2 == null) {
                try {
                    value2 = this.defaultLookup(settings);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Missing mandatory setting '%s'", this.name()));
                }
            }
            if (value2 == null) {
                return null;
            }
            try {
                result2 = this.parser.apply(value2);
                if (this.valueConverters != null) {
                    for (BiFunction<T, Function<String, String>, T> valueConverter : this.valueConverters) {
                        result2 = valueConverter.apply(result2, settings);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new InvalidSettingException(this.name(), value2, e.getMessage());
            }
            return result2;
        }

        @Override
        public String valueDescription() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name()).append(" is ").append(this.parser);
            if (this.valueConverters != null && this.valueConverters.size() > 0) {
                builder.append(" which ");
                boolean first = true;
                for (BiFunction<T, Function<String, String>, T> valueConverter : this.valueConverters) {
                    if (!first) {
                        builder.append(", and ");
                    }
                    builder.append(valueConverter);
                    first = false;
                }
            }
            return builder.toString();
        }
    }

    public static final class SettingBuilder<T> {
        private final String name;
        private final Function<String, T> parser;
        private final String defaultValue;
        private Setting<T> inheritedSetting;
        private List<BiFunction<T, Function<String, String>, T>> valueConstraints;

        private SettingBuilder(@Nonnull String name, @Nonnull Function<String, T> parser, @Nullable String defaultValue) {
            this.name = name;
            this.parser = parser;
            this.defaultValue = defaultValue;
        }

        @Nonnull
        public SettingBuilder<T> inherits(@Nonnull Setting<T> inheritedSetting) {
            if (this.inheritedSetting != null) {
                throw new AssertionError((Object)"Can only inherit from one setting");
            }
            this.inheritedSetting = inheritedSetting;
            return this;
        }

        @Nonnull
        public SettingBuilder<T> constraint(@Nonnull BiFunction<T, Function<String, String>, T> constraint) {
            if (this.valueConstraints == null) {
                this.valueConstraints = new LinkedList<BiFunction<T, Function<String, String>, T>>();
            }
            this.valueConstraints.add(constraint);
            return this;
        }

        @Nonnull
        public Setting<T> build() {
            BiFunction valueLookup = Settings.named();
            BiFunction defaultLookup = Settings.determineDefaultLookup(this.defaultValue, valueLookup);
            if (this.inheritedSetting != null) {
                valueLookup = Settings.inheritedValue(valueLookup, this.inheritedSetting);
                defaultLookup = Settings.inheritedDefault(defaultLookup, this.inheritedSetting);
            }
            return new DefaultSetting<T>(this.name, this.parser, valueLookup, defaultLookup, this.valueConstraints);
        }
    }

    private static interface SettingHelper<T>
    extends Setting<T> {
        public String lookup(Function<String, String> var1);

        public String defaultLookup(Function<String, String> var1);
    }
}

