/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.v1.Value;

public class RunMessage
implements Message {
    public static final byte SIGNATURE = 16;
    private final String statement;
    private final Map<String, Value> parameters;

    public RunMessage(String statement2) {
        this(statement2, Collections.emptyMap());
    }

    public RunMessage(String statement2, Map<String, Value> parameters) {
        this.statement = statement2;
        this.parameters = parameters;
    }

    public String statement() {
        return this.statement;
    }

    public Map<String, Value> parameters() {
        return this.parameters;
    }

    @Override
    public byte signature() {
        return 16;
    }

    public String toString() {
        return String.format("RUN \"%s\" %s", this.statement, this.parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return !(this.parameters == null ? that.parameters != null : !this.parameters.equals(that.parameters)) && !(this.statement == null ? that.statement != null : !this.statement.equals(that.statement));
    }

    public int hashCode() {
        int result2 = this.statement != null ? this.statement.hashCode() : 0;
        result2 = 31 * result2 + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result2;
    }
}

