/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.v1.Value;

public class HandshakeCompletedListener
implements ChannelFutureListener {
    private final String userAgent;
    private final Map<String, Value> authToken;
    private final ChannelPromise connectionInitializedPromise;

    public HandshakeCompletedListener(String userAgent, Map<String, Value> authToken, ChannelPromise connectionInitializedPromise) {
        this.userAgent = Objects.requireNonNull(userAgent);
        this.authToken = Objects.requireNonNull(authToken);
        this.connectionInitializedPromise = Objects.requireNonNull(connectionInitializedPromise);
    }

    @Override
    public void operationComplete(ChannelFuture future) {
        if (future.isSuccess()) {
            BoltProtocol protocol = BoltProtocol.forChannel(future.channel());
            protocol.initializeChannel(this.userAgent, this.authToken, this.connectionInitializedPromise);
        } else {
            this.connectionInitializedPromise.setFailure(future.cause());
        }
    }
}

