/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.time.Clock;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.bolt.logging.BoltMessageLogging;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltSchedulerProvider;
import org.neo4j.bolt.runtime.CachedThreadPoolExecutorFactory;
import org.neo4j.bolt.runtime.DefaultBoltConnectionFactory;
import org.neo4j.bolt.runtime.ExecutorBoltSchedulerProvider;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstallerFactory;
import org.neo4j.bolt.transport.DefaultBoltProtocolPipelineInstallerFactory;
import org.neo4j.bolt.transport.Netty4LoggerFactory;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.SocketTransport;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.runtime.BoltFactoryImpl;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.udc.UsageData;

public class BoltKernelExtension
extends KernelExtensionFactory<Dependencies> {
    public BoltKernelExtension() {
        super("bolt-server");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) {
        Config config = dependencies.config();
        GraphDatabaseService gdb = dependencies.db();
        GraphDatabaseAPI api = (GraphDatabaseAPI)gdb;
        LogService logService = dependencies.logService();
        Clock clock = dependencies.clock();
        SslPolicyLoader sslPolicyFactory = dependencies.sslPolicyFactory();
        Log log = logService.getInternalLog(BoltKernelExtension.class);
        Log userLog = logService.getUserLog(BoltKernelExtension.class);
        LifeSupport life = new LifeSupport();
        JobScheduler scheduler = dependencies.scheduler();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Netty4LoggerFactory(logService.getInternalLogProvider()));
        BoltMessageLogging boltLogging = BoltMessageLogging.create(dependencies.fileSystem(), scheduler, config, log);
        Authentication authentication = this.authentication(dependencies.authManager(), dependencies.userManagerSupplier());
        TransportThrottleGroup throttleGroup = new TransportThrottleGroup(config, clock);
        BoltFactory boltFactory = (BoltFactory)life.add((Lifecycle)new BoltFactoryImpl(api, dependencies.usageData(), logService, dependencies.txBridge(), authentication, dependencies.sessionTracker(), config));
        BoltSchedulerProvider boltSchedulerProvider = (BoltSchedulerProvider)life.add((Lifecycle)new ExecutorBoltSchedulerProvider(config, new CachedThreadPoolExecutorFactory(log), scheduler, logService));
        BoltConnectionFactory boltConnectionFactory = this.createConnectionFactory(config, boltFactory, boltSchedulerProvider, throttleGroup, dependencies, logService, clock);
        ConnectorPortRegister connectionRegister = dependencies.connectionRegister();
        BoltProtocolPipelineInstallerFactory handlerFactory = BoltKernelExtension.createHandlerFactory(boltConnectionFactory, throttleGroup, logService);
        if (!config.enabledBoltConnectors().isEmpty() && !((Boolean)config.get(GraphDatabaseSettings.disconnected)).booleanValue()) {
            NettyServer server = new NettyServer(scheduler.threadFactory(JobScheduler.Groups.boltNetworkIO), this.createConnectors(config, sslPolicyFactory, logService, log, boltLogging, throttleGroup, handlerFactory), connectionRegister, userLog);
            life.add((Lifecycle)server);
            log.info("Bolt Server extension loaded.");
        }
        return life;
    }

    private BoltConnectionFactory createConnectionFactory(Config config, BoltFactory boltFactory, BoltSchedulerProvider schedulerProvider, TransportThrottleGroup throttleGroup, Dependencies dependencies, LogService logService, Clock clock) {
        return new DefaultBoltConnectionFactory(boltFactory, schedulerProvider, throttleGroup, config, logService, clock, dependencies.monitors());
    }

    private Map<BoltConnector, NettyServer.ProtocolInitializer> createConnectors(Config config, SslPolicyLoader sslPolicyFactory, LogService logService, Log log, BoltMessageLogging boltLogging, TransportThrottleGroup throttleGroup, BoltProtocolPipelineInstallerFactory handlerFactory) {
        Map<BoltConnector, NettyServer.ProtocolInitializer> connectors = config.enabledBoltConnectors().stream().collect(Collectors.toMap(Function.identity(), connConfig -> {
            SslContext sslCtx;
            boolean requireEncryption;
            ListenSocketAddress listenAddress = (ListenSocketAddress)config.get(connConfig.listen_address);
            BoltConnector.EncryptionLevel encryptionLevel = (BoltConnector.EncryptionLevel)config.get(connConfig.encryption_level);
            switch (encryptionLevel) {
                case REQUIRED: {
                    requireEncryption = true;
                    sslCtx = this.createSslContext(sslPolicyFactory, config);
                    break;
                }
                case OPTIONAL: {
                    requireEncryption = false;
                    sslCtx = this.createSslContext(sslPolicyFactory, config);
                    break;
                }
                case DISABLED: {
                    requireEncryption = false;
                    sslCtx = null;
                    break;
                }
                default: {
                    log.warn(String.format("Unhandled encryption level %s - assuming DISABLED.", encryptionLevel.name()));
                    requireEncryption = false;
                    sslCtx = null;
                }
            }
            return new SocketTransport(connConfig.key(), listenAddress, sslCtx, requireEncryption, logService.getInternalLogProvider(), boltLogging, throttleGroup, handlerFactory);
        }));
        return connectors;
    }

    private SslContext createSslContext(SslPolicyLoader sslPolicyFactory, Config config) {
        try {
            String policyName = (String)config.get(Settings.ssl_policy);
            if (policyName == null) {
                throw new IllegalArgumentException("No SSL policy has been configured for bolt");
            }
            return sslPolicyFactory.getPolicy(policyName).nettyServerContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize SSL encryption support, which is required to start this connector. Error was: " + e.getMessage(), e);
        }
    }

    private Authentication authentication(AuthManager authManager, UserManagerSupplier userManagerSupplier) {
        return new BasicAuthentication(authManager, userManagerSupplier);
    }

    private static BoltProtocolPipelineInstallerFactory createHandlerFactory(BoltConnectionFactory connectionFactory, TransportThrottleGroup throttleGroup, LogService logService) {
        return new DefaultBoltProtocolPipelineInstallerFactory(connectionFactory, throttleGroup, logService);
    }

    public static interface Dependencies {
        public LogService logService();

        public Config config();

        public GraphDatabaseService db();

        public JobScheduler scheduler();

        public UsageData usageData();

        public Monitors monitors();

        public ThreadToStatementContextBridge txBridge();

        public BoltConnectionTracker sessionTracker();

        public ConnectorPortRegister connectionRegister();

        public Clock clock();

        public AuthManager authManager();

        public UserManagerSupplier userManagerSupplier();

        public SslPolicyLoader sslPolicyFactory();

        public FileSystemAbstraction fileSystem();
    }

    public static class Settings
    implements LoadableConfig {
        @Description(value="Specify the SSL policy to use")
        public static final Setting<String> ssl_policy = org.neo4j.kernel.configuration.Settings.setting((String)"bolt.ssl_policy", (Function)org.neo4j.kernel.configuration.Settings.STRING, (String)"legacy");
    }
}

