/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.SilentProgressReporter;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class CountsComputer
implements DataInitializer<CountsAccessor.Updater> {
    private final NumberArrayFactory numberArrayFactory;
    private final NodeStore nodes;
    private final RelationshipStore relationships;
    private final int highLabelId;
    private final int highRelationshipTypeId;
    private final long lastCommittedTransactionId;
    private final ProgressReporter progressMonitor;

    public static void recomputeCounts(NeoStores stores, PageCache pageCache) {
        MetaDataStore metaDataStore = stores.getMetaDataStore();
        CountsTracker counts = stores.getCounts();
        try (CountsAccessor.Updater updater = counts.reset(metaDataStore.getLastCommittedTransactionId());){
            new CountsComputer(stores, pageCache).initialize(updater);
        }
    }

    public CountsComputer(NeoStores stores, PageCache pageCache) {
        this(stores.getMetaDataStore().getLastCommittedTransactionId(), stores.getNodeStore(), stores.getRelationshipStore(), (int)stores.getLabelTokenStore().getHighId(), (int)stores.getRelationshipTypeTokenStore().getHighId(), NumberArrayFactory.auto(pageCache, stores.getStoreDir(), true, NumberArrayFactory.NO_MONITOR));
    }

    public CountsComputer(long lastCommittedTransactionId, NodeStore nodes, RelationshipStore relationships, int highLabelId, int highRelationshipTypeId, NumberArrayFactory numberArrayFactory) {
        this(lastCommittedTransactionId, nodes, relationships, highLabelId, highRelationshipTypeId, numberArrayFactory, SilentProgressReporter.INSTANCE);
    }

    public CountsComputer(long lastCommittedTransactionId, NodeStore nodes, RelationshipStore relationships, int highLabelId, int highRelationshipTypeId, NumberArrayFactory numberArrayFactory, ProgressReporter progressMonitor) {
        this.lastCommittedTransactionId = lastCommittedTransactionId;
        this.nodes = nodes;
        this.relationships = relationships;
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
        this.numberArrayFactory = numberArrayFactory;
        this.progressMonitor = progressMonitor;
    }

    @Override
    public void initialize(CountsAccessor.Updater countsUpdater) {
        this.progressMonitor.start(this.nodes.getHighestPossibleIdInUse() + this.relationships.getHighestPossibleIdInUse());
        NodeLabelsCache cache = new NodeLabelsCache(this.numberArrayFactory, this.highLabelId);
        try {
            ExecutionSupervisors.superviseDynamicExecution(new NodeCountsStage(Configuration.DEFAULT, cache, this.nodes, this.highLabelId, countsUpdater, this.progressMonitor, new StatsProvider[0]));
            ExecutionSupervisors.superviseDynamicExecution(new RelationshipCountsStage(Configuration.DEFAULT, cache, this.relationships, this.highLabelId, this.highRelationshipTypeId, countsUpdater, this.numberArrayFactory, this.progressMonitor));
        }
        finally {
            cache.close();
            this.progressMonitor.completed();
        }
    }

    @Override
    public long initialVersion() {
        return this.lastCommittedTransactionId;
    }
}

