/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.BatchingMultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.logging.LogProvider;

public abstract class MultiPopulatorFactory {
    private MultiPopulatorFactory() {
    }

    public abstract MultipleIndexPopulator create(IndexStoreView var1, LogProvider var2, SchemaState var3);

    public static MultiPopulatorFactory forConfig(Config config) {
        boolean multiThreaded = config.get(GraphDatabaseSettings.multi_threaded_schema_index_population_enabled);
        return multiThreaded ? new MultiThreadedPopulatorFactory() : new SingleThreadedPopulatorFactory();
    }

    private static class MultiThreadedPopulatorFactory
    extends MultiPopulatorFactory {
        private MultiThreadedPopulatorFactory() {
        }

        @Override
        public MultipleIndexPopulator create(IndexStoreView storeView, LogProvider logProvider, SchemaState schemaState) {
            return new BatchingMultipleIndexPopulator(storeView, logProvider, schemaState);
        }
    }

    private static class SingleThreadedPopulatorFactory
    extends MultiPopulatorFactory {
        private SingleThreadedPopulatorFactory() {
        }

        @Override
        public MultipleIndexPopulator create(IndexStoreView storeView, LogProvider logProvider, SchemaState schemaState) {
            return new MultipleIndexPopulator(storeView, logProvider, schemaState);
        }
    }
}

