/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.jmx;

import java.util.Map;
import org.neo4j.dbms.diagnostics.jmx.Reports;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class ReportsBean
extends ManagementBeanProvider {
    public ReportsBean() {
        super(Reports.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) {
        return new ReportsImpl(management, false);
    }

    protected Neo4jMBean createMXBean(ManagementData management) {
        return new ReportsImpl(management, true);
    }

    private static class ReportsImpl
    extends Neo4jMBean
    implements Reports {
        private final GraphDatabaseAPI graphDatabaseAPI;

        ReportsImpl(ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            this.graphDatabaseAPI = management.getKernelData().graphDatabase();
        }

        @Override
        public String listTransactions() {
            String res;
            try (Transaction tx = this.graphDatabaseAPI.beginTx();){
                res = this.graphDatabaseAPI.execute("CALL dbms.listTransactions()").resultAsString();
                tx.success();
            }
            catch (QueryExecutionException e) {
                res = "dbms.listTransactions() is not available";
            }
            return res;
        }

        @Override
        public String getEnvironmentVariables() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> env : System.getenv().entrySet()) {
                sb.append(env.getKey()).append('=').append(env.getValue()).append('\n');
            }
            return sb.toString();
        }
    }
}

