/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.schema;

import java.util.Optional;
import java.util.function.Predicate;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;

public class SchemaDescriptorPredicates {
    private static SchemaComputer<Optional<Integer>> getLabel = new SchemaComputer<Optional<Integer>>(){

        @Override
        public Optional<Integer> computeSpecific(LabelSchemaDescriptor schema) {
            return Optional.of(schema.getLabelId());
        }

        @Override
        public Optional<Integer> computeSpecific(RelationTypeSchemaDescriptor schema) {
            return Optional.empty();
        }
    };
    private static SchemaComputer<Optional<Integer>> getRelType = new SchemaComputer<Optional<Integer>>(){

        @Override
        public Optional<Integer> computeSpecific(LabelSchemaDescriptor schema) {
            return Optional.empty();
        }

        @Override
        public Optional<Integer> computeSpecific(RelationTypeSchemaDescriptor schema) {
            return Optional.of(schema.getRelTypeId());
        }
    };

    private SchemaDescriptorPredicates() {
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> hasLabel(int labelId) {
        return supplier -> {
            Optional<Integer> labelOpt = supplier.schema().computeWith(getLabel);
            return labelOpt.isPresent() && labelOpt.get() == labelId;
        };
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> hasRelType(int relTypeId) {
        return supplier -> {
            Optional<Integer> relTypeOpt = supplier.schema().computeWith(getRelType);
            return relTypeOpt.isPresent() && relTypeOpt.get() == relTypeId;
        };
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> hasProperty(int propertyId) {
        return supplier -> SchemaDescriptorPredicates.hasProperty(supplier, propertyId);
    }

    public static boolean hasLabel(SchemaDescriptorSupplier supplier, int labelId) {
        Optional<Integer> labelOpt = supplier.schema().computeWith(getLabel);
        return labelOpt.isPresent() && labelOpt.get() == labelId;
    }

    public static boolean hasRelType(SchemaDescriptorSupplier supplier, int relTypeId) {
        Optional<Integer> relTypeOpt = supplier.schema().computeWith(getRelType);
        return relTypeOpt.isPresent() && relTypeOpt.get() == relTypeId;
    }

    public static boolean hasProperty(SchemaDescriptorSupplier supplier, int propertyId) {
        int[] schemaProperties;
        for (int schemaProp : schemaProperties = supplier.schema().getPropertyIds()) {
            if (schemaProp != propertyId) continue;
            return true;
        }
        return false;
    }
}

