/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.CommandUsage;

public class Usage {
    private final String scriptName;
    private final CommandLocator commands;

    public Usage(String scriptName, CommandLocator commands) {
        this.scriptName = scriptName;
        this.commands = commands;
    }

    public void printUsageForCommand(AdminCommand.Provider command, Consumer<String> output) {
        CommandUsage commandUsage = new CommandUsage(command, this.scriptName);
        commandUsage.printDetailed(output);
    }

    public void print(Consumer<String> output) {
        output.accept(String.format("usage: %s <command>", this.scriptName));
        output.accept("");
        output.accept("Manage your ONgDB instance.");
        output.accept("");
        Usage.printEnvironmentVariables(output);
        output.accept("available commands:");
        this.printCommands(output);
        output.accept("");
        output.accept(String.format("Use %s help <command> for more details.", this.scriptName));
    }

    static void printEnvironmentVariables(Consumer<String> output) {
        output.accept("environment variables:");
        output.accept("    ONGDB_CONF    Path to directory which contains ongdb.conf.");
        output.accept("    ONGDB_DEBUG   Set to anything to enable debug output.");
        output.accept("    ONGDB_HOME    ONgDB home directory.");
        output.accept("    HEAP_SIZE     Set JVM maximum heap size during command execution.");
        output.accept("                  Takes a number and a unit, for example 512m.");
        output.accept("");
    }

    private void printCommands(Consumer<String> output) {
        Map<AdminCommandSection, List<AdminCommand.Provider>> groupedProviders = this.groupProvidersBySection();
        AdminCommandSection.general().printAllCommandsUnderSection(output, groupedProviders.remove(AdminCommandSection.general()));
        groupedProviders.entrySet().stream().sorted(Comparator.comparing(groupedProvider -> ((AdminCommandSection)groupedProvider.getKey()).printable())).forEach(entry -> ((AdminCommandSection)entry.getKey()).printAllCommandsUnderSection(output, (List)entry.getValue()));
    }

    private Map<AdminCommandSection, List<AdminCommand.Provider>> groupProvidersBySection() {
        ArrayList providers = new ArrayList();
        this.commands.getAllProviders().forEach(providers::add);
        return providers.stream().collect(Collectors.groupingBy(AdminCommand.Provider::commandSection));
    }
}

