/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class ExecutionPlanConverter {
    private ExecutionPlanConverter() {
    }

    public static MapValue convert(ExecutionPlanDescription plan) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("operatorType", Values.stringValue((String)plan.getName()));
        out.put("args", ValueUtils.asMapValue((Map)plan.getArguments()));
        out.put("identifiers", ValueUtils.asListValue((Iterable)plan.getIdentifiers()));
        out.put("children", ExecutionPlanConverter.children(plan));
        if (plan.hasProfilerStatistics()) {
            ExecutionPlanDescription.ProfilerStatistics profile = plan.getProfilerStatistics();
            out.put("dbHits", Values.longValue((long)profile.getDbHits()));
            out.put("pageCacheHits", Values.longValue((long)profile.getPageCacheHits()));
            out.put("pageCacheMisses", Values.longValue((long)profile.getPageCacheMisses()));
            out.put("pageCacheHitRatio", Values.doubleValue((double)profile.getPageCacheHitRatio()));
            out.put("rows", Values.longValue((long)profile.getRows()));
        }
        return VirtualValues.map(out);
    }

    private static ListValue children(ExecutionPlanDescription plan) {
        LinkedList<MapValue> children = new LinkedList<MapValue>();
        for (ExecutionPlanDescription child : plan.getChildren()) {
            children.add(ExecutionPlanConverter.convert(child));
        }
        return VirtualValues.fromList(children);
    }
}

