/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.CommonAbstractStore;

public abstract class HighIdAwareIterator<STORE extends CommonAbstractStore<?, ?>>
extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
    protected final STORE store;
    private long highId;

    HighIdAwareIterator(STORE store) {
        this.store = store;
        this.highId = ((CommonAbstractStore)store).getHighestPossibleIdInUse();
    }

    protected final boolean fetchNext() {
        while (true) {
            boolean fetched;
            if (fetched = this.doFetchNext(this.highId)) {
                return true;
            }
            long newHighId = ((CommonAbstractStore)this.store).getHighestPossibleIdInUse();
            if (newHighId <= this.highId) break;
            this.highId = newHighId;
        }
        return false;
    }

    protected abstract boolean doFetchNext(long var1);
}

