/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class RFC1123 {
    private static final ThreadLocal<RFC1123> INSTANCES = new ThreadLocal();
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Date Y2K_START_DATE;
    private final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);

    private RFC1123() {
        this.format.setTimeZone(GMT);
    }

    public Date parse(String input) throws ParseException {
        this.format.set2DigitYearStart(Y2K_START_DATE);
        return this.format.parse(input);
    }

    public String format(Date date) {
        if (null == date) {
            throw new IllegalArgumentException("Date is null");
        }
        return this.format.format(date);
    }

    static RFC1123 instance() {
        RFC1123 instance = INSTANCES.get();
        if (null == instance) {
            instance = new RFC1123();
            INSTANCES.set(instance);
        }
        return instance;
    }

    public static Date parseTimestamp(String input) throws ParseException {
        return RFC1123.instance().parse(input);
    }

    public static String formatDate(Date date) {
        return RFC1123.instance().format(date);
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        Y2K_START_DATE = calendar.getTime();
    }
}

