/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.hopscotch.PowerOfTwoQuantizedTable;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public abstract class UnsafeTable<VALUE>
extends PowerOfTwoQuantizedTable<VALUE> {
    private final int bytesPerKey;
    private final int bytesPerEntry;
    private final long dataSize;
    private final long allocatedBytes;
    private final long allocatedAddress;
    private final long address;
    protected final VALUE valueMarker;
    protected final MemoryAllocationTracker allocationTracker;

    protected UnsafeTable(int capacity, int bytesPerKey, VALUE valueMarker, MemoryAllocationTracker allocationTracker) {
        super(capacity, 32);
        UnsafeUtil.assertHasUnsafe();
        this.allocationTracker = allocationTracker;
        this.bytesPerKey = bytesPerKey;
        this.bytesPerEntry = 4 + bytesPerKey;
        this.valueMarker = valueMarker;
        this.dataSize = (long)this.capacity * (long)this.bytesPerEntry;
        assert (this.bytesPerEntry % 4 == 0) : "Bytes per entry needs to be divisible by 4, this constraint is checked because on memory systems requiring aligned memory access this would otherwise break.";
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            this.allocatedBytes = this.dataSize;
            this.allocatedAddress = this.address = UnsafeUtil.allocateMemory((long)this.allocatedBytes, (MemoryAllocationTracker)this.allocationTracker);
        } else {
            if (this.bytesPerEntry % 4 != 0) {
                throw new IllegalArgumentException("Memory system requires aligned memory access and " + this.getClass().getSimpleName() + " was designed to cope with this requirement by being able to accessing data in 4-byte chunks, if needed to. Although this table tried to be constructed with bytesPerKey:" + bytesPerKey + " yielding a bytesPerEntry:" + this.bytesPerEntry + ", which isn't 4-byte aligned.");
            }
            this.allocatedBytes = this.dataSize + 4L - 1L;
            this.allocatedAddress = UnsafeUtil.allocateMemory((long)this.allocatedBytes, (MemoryAllocationTracker)this.allocationTracker);
            this.address = UnsafeUtil.alignedMemory((long)this.allocatedAddress, (int)4);
        }
        this.clearMemory();
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.clearMemory();
        }
        super.clear();
    }

    private void clearMemory() {
        UnsafeUtil.setMemory((long)this.address, (long)this.dataSize, (byte)-1);
    }

    @Override
    public long key(int index) {
        return this.internalKey(this.keyAddress(index));
    }

    protected abstract long internalKey(long var1);

    @Override
    public VALUE value(int index) {
        return this.valueMarker;
    }

    @Override
    public void put(int index, long key, VALUE value) {
        this.internalPut(this.keyAddress(index), key, value);
        ++this.size;
    }

    protected abstract void internalPut(long var1, long var3, VALUE var5);

    @Override
    public VALUE putValue(int index, VALUE value) {
        return value;
    }

    @Override
    public long move(int fromIndex, int toIndex) {
        long adr = this.keyAddress(fromIndex);
        long key = this.internalKey(adr);
        VALUE value = this.internalRemove(adr);
        this.internalPut(this.keyAddress(toIndex), key, value);
        return key;
    }

    @Override
    public VALUE remove(int index) {
        VALUE value = this.internalRemove(this.keyAddress(index));
        --this.size;
        return value;
    }

    protected VALUE internalRemove(long keyAddress) {
        UnsafeUtil.setMemory((long)keyAddress, (long)this.bytesPerKey, (byte)-1);
        return this.valueMarker;
    }

    @Override
    public long hopBits(int index) {
        return ((long)UnsafeUtil.getInt((long)this.hopBitsAddress(index)) | 0xFFFFFFFF00000000L) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void putHopBit(int index, int hd) {
        long adr = this.hopBitsAddress(index);
        int hopBits = UnsafeUtil.getInt((long)adr);
        UnsafeUtil.putInt((long)adr, (int)(hopBits &= ~(1 << hd)));
    }

    @Override
    public void moveHopBit(int index, int hd, int delta) {
        long adr = this.hopBitsAddress(index);
        int hopBits = UnsafeUtil.getInt((long)adr);
        UnsafeUtil.putInt((long)adr, (int)(hopBits ^= 1 << hd | 1 << hd + delta));
    }

    protected long keyAddress(int index) {
        return this.address + (long)index * (long)this.bytesPerEntry + 4L;
    }

    protected long hopBitsAddress(int index) {
        return this.address + (long)index * (long)this.bytesPerEntry;
    }

    @Override
    public void removeHopBit(int index, int hd) {
        long adr = this.hopBitsAddress(index);
        int hopBits = UnsafeUtil.getInt((long)adr);
        UnsafeUtil.putInt((long)adr, (int)(hopBits |= 1 << hd));
    }

    @Override
    public void close() {
        UnsafeUtil.free((long)this.allocatedAddress, (long)this.allocatedBytes, (MemoryAllocationTracker)this.allocationTracker);
    }

    protected static void alignmentSafePutLongAsTwoInts(long address, long value) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putLong((long)address, (long)value);
        } else {
            UnsafeUtil.putInt((long)address, (int)((int)value));
            UnsafeUtil.putInt((long)(address + 4L), (int)((int)(value >>> 32)));
        }
    }

    protected static long alignmentSafeGetLongAsTwoInts(long address) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            return UnsafeUtil.getLong((long)address);
        }
        long lsb = (long)UnsafeUtil.getInt((long)address) & 0xFFFFFFFFL;
        long msb = (long)UnsafeUtil.getInt((long)(address + 4L)) & 0xFFFFFFFFL;
        return lsb | msb << 32;
    }
}

