/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.DurationSchemaKey;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;

class DurationLayout
extends SchemaLayout<DurationSchemaKey> {
    DurationLayout() {
        super("Tdu", 0, 1);
    }

    public DurationSchemaKey newKey() {
        return new DurationSchemaKey();
    }

    public DurationSchemaKey copyKey(DurationSchemaKey key, DurationSchemaKey into) {
        into.totalAvgSeconds = key.totalAvgSeconds;
        into.nanosOfSecond = key.nanosOfSecond;
        into.months = key.months;
        into.days = key.days;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(DurationSchemaKey key) {
        return 36;
    }

    public void writeKey(PageCursor cursor, DurationSchemaKey key) {
        cursor.putLong(key.totalAvgSeconds);
        cursor.putInt(key.nanosOfSecond);
        cursor.putLong(key.months);
        cursor.putLong(key.days);
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, DurationSchemaKey into, int keySize) {
        into.totalAvgSeconds = cursor.getLong();
        into.nanosOfSecond = cursor.getInt();
        into.months = cursor.getLong();
        into.days = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }
}

