/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.storageengine.api.Token;

public class InMemoryTokenCache<TOKEN extends Token> {
    private final Map<String, Integer> nameToId = new CopyOnWriteHashMap<String, Integer>();
    private final Map<Integer, TOKEN> idToToken = new CopyOnWriteHashMap<Integer, TOKEN>();
    private final String tokenType;

    public InMemoryTokenCache(String tokenType) {
        this.tokenType = tokenType;
    }

    public void clear() {
        this.nameToId.clear();
        this.idToToken.clear();
    }

    private void putAndEnsureUnique(Map<String, Integer> nameToId, TOKEN token, String tokenType) {
        Integer previous = nameToId.putIfAbsent(((Token)token).name(), ((Token)token).id());
        if (previous != null && previous.intValue() != ((Token)token).id()) {
            this.idToToken.remove(((Token)token).id(), token);
            throw new NonUniqueTokenException(tokenType, ((Token)token).name(), ((Token)token).id(), previous);
        }
    }

    public void putAll(List<TOKEN> tokens) throws NonUniqueTokenException {
        HashMap<String, Integer> newNameToId = new HashMap<String, Integer>();
        HashMap<Integer, Token> newIdToToken = new HashMap<Integer, Token>();
        for (Token token : tokens) {
            newIdToToken.put(token.id(), token);
            this.putAndEnsureUnique(newNameToId, token, this.tokenType);
        }
        this.idToToken.putAll(newIdToToken);
        this.nameToId.putAll(newNameToId);
    }

    public void put(TOKEN token) throws NonUniqueTokenException {
        this.idToToken.put(((Token)token).id(), token);
        this.putAndEnsureUnique(this.nameToId, token, this.tokenType);
    }

    public Integer getId(String name) {
        return this.nameToId.get(name);
    }

    public TOKEN getToken(int id) {
        return (TOKEN)((Token)this.idToToken.get(id));
    }

    public Iterable<TOKEN> allTokens() {
        return Collections.unmodifiableCollection(this.idToToken.values());
    }

    public int size() {
        return this.nameToId.size();
    }
}

