/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;

public abstract class DelegatingPath
implements Path {
    private final Path delegate;
    private final FileSystem filesystem;

    public DelegatingPath(Path delegate) {
        this(delegate, delegate.getFileSystem());
    }

    public DelegatingPath(Path delegate, FileSystem fs) {
        this.delegate = delegate;
        this.filesystem = fs;
    }

    public Path getDelegate() {
        return this.delegate;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.filesystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    @Override
    public Path getRoot() {
        return this.wrapPath(this.delegate.getRoot());
    }

    @Override
    public Path getFileName() {
        return this.wrapPath(this.delegate.getFileName());
    }

    @Override
    public Path getParent() {
        return this.wrapPath(this.delegate.getParent());
    }

    @Override
    public int getNameCount() {
        return this.delegate.getNameCount();
    }

    @Override
    public Path getName(int index) {
        return this.wrapPath(this.delegate.getName(index));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return this.wrapPath(this.delegate.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        return this.delegate.startsWith(DelegatingPath.getDelegate(other));
    }

    @Override
    public boolean startsWith(String other) {
        return this.delegate.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        return this.delegate.endsWith(DelegatingPath.getDelegate(other));
    }

    @Override
    public boolean endsWith(String other) {
        return this.delegate.endsWith(other);
    }

    @Override
    public Path normalize() {
        return this.wrapPath(this.delegate.normalize());
    }

    @Override
    public Path resolve(Path other) {
        return this.wrapPath(this.delegate.resolve(DelegatingPath.getDelegate(other)));
    }

    @Override
    public Path resolve(String other) {
        return this.wrapPath(this.delegate.resolve(other));
    }

    @Override
    public Path resolveSibling(Path other) {
        return this.wrapPath(this.delegate.resolveSibling(DelegatingPath.getDelegate(other)));
    }

    @Override
    public Path resolveSibling(String other) {
        return this.wrapPath(this.delegate.resolveSibling(other));
    }

    @Override
    public Path relativize(Path other) {
        return this.wrapPath(this.delegate.relativize(DelegatingPath.getDelegate(other)));
    }

    @Override
    public URI toUri() {
        return this.delegate.toUri();
    }

    @Override
    public Path toAbsolutePath() {
        return this.wrapPath(this.delegate.toAbsolutePath());
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.wrapPath(this.delegate.toRealPath(options));
    }

    @Override
    public File toFile() {
        return this.delegate.toFile();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        final Iterator<Path> delegateIterator = this.delegate.iterator();
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                return delegateIterator.hasNext();
            }

            @Override
            public Path next() {
                return DelegatingPath.this.wrapPath((Path)delegateIterator.next());
            }

            @Override
            public void remove() {
                delegateIterator.remove();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        return this.delegate.compareTo(other);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Path wrapPath(Path path) {
        return path == null ? null : this.createDelegate(path);
    }

    protected abstract Path createDelegate(Path var1);

    public static Path getDelegate(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof DelegatingPath)) {
            throw new ProviderMismatchException();
        }
        return ((DelegatingPath)path).getDelegate();
    }
}

