/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import org.neo4j.configuration.Description;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Settings for the remote shell extension")
public class ShellSettings
implements LoadableConfig {
    @Description(value="Enable a remote shell server which ONgDB Shell clients can log in to. Only applicable to `ongdb-shell`.")
    public static final Setting<Boolean> remote_shell_enabled = Settings.setting("dbms.shell.enabled", Settings.BOOLEAN, "false");
    @Description(value="Remote host for shell. By default, the shell server listens only on the loopback interface, but you can specify the IP address of any network interface or use `0.0.0.0` for all interfaces. Only applicable to `ongdb-shell`.")
    public static final Setting<String> remote_shell_host = Settings.buildSetting("dbms.shell.host", Settings.STRING, "127.0.0.1").constraint(Settings.illegalValueMessage("must be a valid name", Settings.matches(".+"))).build();
    @Description(value="The port the shell will listen on. Only applicable to `ongdb-shell`.")
    public static final Setting<Integer> remote_shell_port = Settings.buildSetting("dbms.shell.port", Settings.INTEGER, "1337").constraint(Settings.port).build();
    @Description(value="Read only mode. Will only allow read operations. Only applicable to `ongdb-shell`.")
    public static final Setting<Boolean> remote_shell_read_only = Settings.setting("dbms.shell.read_only", Settings.BOOLEAN, "false");
    @Description(value="The name of the shell. Only applicable to `ongdb-shell`.")
    public static final Setting<String> remote_shell_name = Settings.buildSetting("dbms.shell.rmi_name", Settings.STRING, "shell").constraint(Settings.illegalValueMessage("must be a valid name", Settings.matches(".+"))).build();
}

