/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Comparator;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ValueTuple {
    private final Value[] values;
    public static final Comparator<ValueTuple> COMPARATOR = (left2, right2) -> {
        if (left2.values.length != right2.values.length) {
            throw new IllegalStateException("Comparing two ValueTuples of different lengths!");
        }
        int compare = 0;
        for (int i = 0; i < left2.values.length; ++i) {
            compare = Values.COMPARATOR.compare(left2.valueAt(i), right2.valueAt(i));
            if (compare == 0) continue;
            return compare;
        }
        return compare;
    };

    public static ValueTuple of(Value ... values2) {
        assert (values2.length > 0) : "Empty ValueTuple is not allowed";
        assert (ValueTuple.noNulls(values2));
        return new ValueTuple(values2);
    }

    public static ValueTuple of(Object ... objects) {
        assert (objects.length > 0) : "Empty ValueTuple is not allowed";
        assert (ValueTuple.noNulls(objects));
        Value[] values2 = new Value[objects.length];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = Values.of(objects[i]);
        }
        return new ValueTuple(values2);
    }

    protected ValueTuple(Value[] values2) {
        this.values = values2;
    }

    public int size() {
        return this.values.length;
    }

    public Value valueAt(int offset) {
        return this.values[offset];
    }

    public Value[] getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueTuple that = (ValueTuple)o;
        if (that.values.length != this.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(that.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = 1;
        for (Value value2 : this.values) {
            result2 = 31 * result2 + ((Object)value2).hashCode();
        }
        return result2;
    }

    public Value getOnlyValue() {
        assert (this.values.length == 1) : "Assumed single value tuple, but had " + this.values.length;
        return this.values[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "( ";
        for (Value value2 : this.values) {
            sb.append(sep);
            sep = ", ";
            sb.append(value2);
        }
        sb.append(" )");
        return sb.toString();
    }

    private static boolean noNulls(Object[] values2) {
        for (Object v : values2) {
            if (v != null) continue;
            return false;
        }
        return true;
    }
}

