/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.kernel.impl.util.Bits;

public class LongBitsManipulator {
    private final Slot[] slots;

    public LongBitsManipulator(int ... slotsAndTheirBitCounts) {
        this.slots = this.intoSlots(slotsAndTheirBitCounts);
    }

    private Slot[] intoSlots(int[] slotsAndTheirSizes) {
        Slot[] slots = new Slot[slotsAndTheirSizes.length];
        int bitCursor = 0;
        for (int i = 0; i < slotsAndTheirSizes.length; ++i) {
            int bits2 = slotsAndTheirSizes[i];
            long mask = (1L << bits2) - 1L;
            slots[i] = new Slot(bits2, mask <<= bitCursor, bitCursor);
            bitCursor += bits2;
        }
        return slots;
    }

    public long set(long field2, int slotIndex, long value2) {
        return this.slot(slotIndex).set(field2, value2);
    }

    public long get(long field2, int slotIndex) {
        return this.slot(slotIndex).get(field2);
    }

    public long clear(long field2, int slotIndex, boolean trueForAllOnes) {
        return this.slot(slotIndex).clear(field2, trueForAllOnes);
    }

    public long template(boolean ... trueForOnes) {
        if (trueForOnes.length != this.slots.length) {
            throw new IllegalArgumentException("Invalid boolean arguments, expected " + this.slots.length);
        }
        long field2 = 0L;
        for (int i = 0; i < trueForOnes.length; ++i) {
            field2 = this.slots[i].clear(field2, trueForOnes[i]);
        }
        return field2;
    }

    private Slot slot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.slots.length) {
            throw new IllegalArgumentException("Invalid slot " + slotIndex + ", I've got " + this);
        }
        return this.slots[slotIndex];
    }

    public String toString() {
        return Arrays.toString(this.slots);
    }

    private static class Slot {
        private final long mask;
        private final long maxValue;
        private final int bitOffset;

        Slot(int bits2, long mask, int bitOffset) {
            this.mask = mask;
            this.bitOffset = bitOffset;
            this.maxValue = (1L << bits2) - 1L;
        }

        public long get(long field2) {
            long raw2 = field2 & this.mask;
            return raw2 == this.mask ? -1L : raw2 >>> this.bitOffset;
        }

        public long set(long field2, long value2) {
            if (value2 < -1L || value2 > this.maxValue) {
                throw new IllegalStateException("Invalid value " + value2 + ", max is " + this.maxValue);
            }
            long otherBits = field2 & (this.mask ^ 0xFFFFFFFFFFFFFFFFL);
            return value2 << this.bitOffset & this.mask | otherBits;
        }

        public long clear(long field2, boolean trueForAllOnes) {
            long otherBits = field2 & (this.mask ^ 0xFFFFFFFFFFFFFFFFL);
            return trueForAllOnes ? otherBits | this.mask : otherBits;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Bits.numbersToBitString(new long[]{this.maxValue << this.bitOffset}) + "]";
        }
    }
}

