/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.ForkedProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class CalculateDenseNodesStep
extends ForkedProcessorStep<RelationshipRecord[]> {
    private final NodeRelationshipCache cache;

    public CalculateDenseNodesStep(StageControl control, Configuration config, NodeRelationshipCache cache, StatsProvider ... statsProviders) {
        super(control, "CALCULATE", config, statsProviders);
        this.cache = cache;
    }

    @Override
    protected void forkedProcess(int id2, int processors, RelationshipRecord[] batch) {
        for (RelationshipRecord record : batch) {
            if (!record.inUse()) continue;
            long startNodeId = record.getFirstNode();
            long endNodeId = record.getSecondNode();
            this.processNodeId(id2, processors, startNodeId);
            if (startNodeId == endNodeId) continue;
            this.processNodeId(id2, processors, endNodeId);
        }
    }

    private void processNodeId(int id2, int processors, long nodeId) {
        if (nodeId % (long)processors == (long)id2) {
            this.cache.incrementCount(nodeId);
        }
    }
}

