/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.shell.prettyprint.OutputFormatter;

class TablePlanFormatter {
    private static final String UNNAMED_PATTERN_STRING = "  (UNNAMED|FRESHID|AGGREGATION)(\\d+)";
    private static final Pattern UNNAMED_PATTERN = Pattern.compile("  (UNNAMED|FRESHID|AGGREGATION)(\\d+)");
    private static final String OPERATOR = "Operator";
    private static final String ESTIMATED_ROWS = "Estimated Rows";
    private static final String ROWS = "Rows";
    private static final String HITS = "DB Hits";
    private static final String PAGE_CACHE = "Cache H/M";
    private static final String TIME = "Time (ms)";
    private static final String ORDER = "Ordered by";
    private static final String IDENTIFIERS = "Identifiers";
    private static final String OTHER = "Other";
    private static final String SEPARATOR = ", ";
    private static final Pattern DEDUP_PATTERN = Pattern.compile("\\s*(\\S+)@\\d+");
    private static final List<String> HEADERS = Arrays.asList("Operator", "Estimated Rows", "Rows", "DB Hits", "Cache H/M", "Time (ms)", "Identifiers", "Ordered by", "Other");
    private static final Set<String> IGNORED_ARGUMENTS = new LinkedHashSet<String>(Arrays.asList("Rows", "DbHits", "EstimatedRows", "planner", "planner-impl", "planner-version", "version", "runtime", "runtime-impl", "runtime-version", "time", "source-code", "PageCacheMisses", "PageCacheHits", "PageCacheHitRatio", "Order"));
    public static final Value ZERO_VALUE = Values.value(0);

    TablePlanFormatter() {
    }

    private int width(@Nonnull String header, @Nonnull Map<String, Integer> columns) {
        return 2 + Math.max(header.length(), columns.get(header));
    }

    private void pad(int width, char chr, @Nonnull StringBuilder result2) {
        result2.append(OutputFormatter.repeat(chr, width));
    }

    private void divider(@Nonnull List<String> headers, @Nullable Line line, @Nonnull StringBuilder result2, @Nonnull Map<String, Integer> columns) {
        for (String header : headers) {
            if (line != null && header.equals(OPERATOR) && line.connection.isPresent()) {
                result2.append("|");
                String connection = (String)line.connection.get();
                result2.append(" ").append(connection);
                this.pad(this.width(header, columns) - connection.length() - 1, ' ', result2);
                continue;
            }
            result2.append("+");
            this.pad(this.width(header, columns), '-', result2);
        }
        result2.append("+").append(OutputFormatter.NEWLINE);
    }

    @Nonnull
    String formatPlan(@Nonnull Plan plan) {
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        List<Line> lines2 = this.accumulate(plan, new Root(), columns);
        List<String> headers = HEADERS.stream().filter(columns::containsKey).collect(Collectors.toList());
        StringBuilder result2 = new StringBuilder((2 + OutputFormatter.NEWLINE.length() + headers.stream().mapToInt(h -> this.width((String)h, (Map<String, Integer>)columns)).sum()) * (lines2.size() * 2 + 3));
        ArrayList<Line> allLines = new ArrayList<Line>();
        Map<String, Justified> headerMap = headers.stream().map(header -> Pair.of(header, new Left((String)header))).collect(Collectors.toMap(p -> (String)p._1, p -> (Left)p._2));
        allLines.add(new Line(OPERATOR, headerMap, Optional.empty()));
        allLines.addAll(lines2);
        for (Line line : allLines) {
            this.divider(headers, line, result2, columns);
            for (String header2 : headers) {
                Justified detail = line.get(header2);
                result2.append("| ");
                if (detail instanceof Left) {
                    result2.append(detail.text);
                    this.pad(this.width(header2, columns) - detail.length - 2, ' ', result2);
                }
                if (detail instanceof Right) {
                    this.pad(this.width(header2, columns) - detail.length - 2, ' ', result2);
                    result2.append(detail.text);
                }
                result2.append(" ");
            }
            result2.append("|").append(OutputFormatter.NEWLINE);
        }
        this.divider(headers, null, result2, columns);
        return result2.toString();
    }

    @Nonnull
    private String serialize(@Nonnull String key, @Nonnull Value v) {
        switch (key) {
            case "ColumnsLeft": {
                return this.removeGeneratedNames(v.asString());
            }
            case "LegacyExpression": {
                return this.removeGeneratedNames(v.asString());
            }
            case "Expression": {
                return this.removeGeneratedNames(v.asString());
            }
            case "UpdateActionName": {
                return v.asString();
            }
            case "LegacyIndex": {
                return v.toString();
            }
            case "version": {
                return v.toString();
            }
            case "planner": {
                return v.toString();
            }
            case "planner-impl": {
                return v.toString();
            }
            case "runtime": {
                return v.toString();
            }
            case "runtime-impl": {
                return v.toString();
            }
            case "MergePattern": {
                return "MergePattern(" + v.toString() + ")";
            }
            case "DbHits": {
                return v.asNumber().toString();
            }
            case "Rows": {
                return v.asNumber().toString();
            }
            case "Time": {
                return v.asNumber().toString();
            }
            case "EstimatedRows": {
                return v.asNumber().toString();
            }
            case "LabelName": {
                return v.asString();
            }
            case "KeyNames": {
                return this.removeGeneratedNames(v.asString());
            }
            case "KeyExpressions": {
                return String.join((CharSequence)SEPARATOR, v.asList(Value::asString));
            }
            case "ExpandExpression": {
                return this.removeGeneratedNames(v.asString());
            }
            case "Index": {
                return v.asString();
            }
            case "PrefixIndex": {
                return v.asString();
            }
            case "InequalityIndex": {
                return v.asString();
            }
            case "EntityByIdRhs": {
                return v.asString();
            }
            case "PageCacheMisses": {
                return v.asNumber().toString();
            }
        }
        return v.asObject().toString();
    }

    @Nonnull
    private Stream<List<Line>> children(@Nonnull Plan plan, Level level, @Nonnull Map<String, Integer> columns) {
        List<? extends Plan> c = plan.children();
        switch (c.size()) {
            case 0: {
                return Stream.empty();
            }
            case 1: {
                return Stream.of(this.accumulate(c.get(0), level.child(), columns));
            }
            case 2: {
                return Stream.of(this.accumulate(c.get(1), level.fork(), columns), this.accumulate(c.get(0), level.child(), columns));
            }
        }
        throw new IllegalStateException("Plan has more than 2 children " + c);
    }

    @Nonnull
    private List<Line> accumulate(@Nonnull Plan plan, @Nonnull Level level, @Nonnull Map<String, Integer> columns) {
        String line = level.line() + plan.operatorType();
        this.mapping(OPERATOR, new Left(line), columns);
        return Stream.concat(Stream.of(new Line(line, this.details(plan, columns), level.connector())), this.children(plan, level, columns).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    @Nonnull
    private Map<String, Justified> details(@Nonnull Plan plan, @Nonnull Map<String, Integer> columns) {
        Map<String, Value> args = plan.arguments();
        Stream<Optional> formattedPlan = args.entrySet().stream().map(e -> {
            Value value2 = (Value)e.getValue();
            switch ((String)e.getKey()) {
                case "EstimatedRows": {
                    return this.mapping(ESTIMATED_ROWS, new Right(this.format(value2.asDouble())), columns);
                }
                case "Rows": {
                    return this.mapping(ROWS, new Right(value2.asNumber().toString()), columns);
                }
                case "DbHits": {
                    return this.mapping(HITS, new Right(value2.asNumber().toString()), columns);
                }
                case "PageCacheHits": {
                    return this.mapping(PAGE_CACHE, new Right(String.format("%s/%s", value2.asNumber(), args.getOrDefault("PageCacheMisses", ZERO_VALUE).asNumber())), columns);
                }
                case "Time": {
                    return this.mapping(TIME, new Right(String.format("%.3f", (double)value2.asLong() / 1000000.0)), columns);
                }
                case "Order": {
                    return this.mapping(ORDER, new Left(String.format("%s", value2.asString())), columns);
                }
            }
            return Optional.empty();
        });
        return Stream.concat(formattedPlan, Stream.of(Optional.of(Pair.of(IDENTIFIERS, new Left(this.identifiers(plan, columns)))), Optional.of(Pair.of(OTHER, new Left(this.other(plan, columns)))))).filter(Optional::isPresent).collect(Collectors.toMap(o -> (String)((Pair)o.get())._1, o -> (Justified)((Pair)o.get())._2));
    }

    @Nonnull
    private Optional<Pair<String, Justified>> mapping(@Nonnull String key, @Nonnull Justified value2, @Nonnull Map<String, Integer> columns) {
        this.update(columns, key, value2.length);
        return Optional.of(Pair.of(key, value2));
    }

    @Nonnull
    private String replaceAllIn(@Nonnull Pattern pattern, @Nonnull String s2, @Nonnull Function<Matcher, String> mapper) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(s2);
        while (matcher.find()) {
            matcher.appendReplacement(sb, mapper.apply(matcher));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Nonnull
    private String removeGeneratedNames(@Nonnull String s2) {
        String named = this.replaceAllIn(UNNAMED_PATTERN, s2, m -> "anon[" + m.group(2) + "]");
        return this.replaceAllIn(DEDUP_PATTERN, named, m -> m.group(1));
    }

    private void update(@Nonnull Map<String, Integer> columns, @Nonnull String key, int length2) {
        columns.put(key, Math.max(columns.getOrDefault(key, 0), length2));
    }

    @Nonnull
    private String identifiers(@Nonnull Plan description, @Nonnull Map<String, Integer> columns) {
        String result2 = description.identifiers().stream().map(this::removeGeneratedNames).collect(Collectors.joining(SEPARATOR));
        if (!result2.isEmpty()) {
            this.update(columns, IDENTIFIERS, result2.length());
        }
        return result2;
    }

    @Nonnull
    private String other(@Nonnull Plan description, @Nonnull Map<String, Integer> columns) {
        String result2 = description.arguments().entrySet().stream().map(e -> {
            if (!IGNORED_ARGUMENTS.contains(e.getKey())) {
                return this.serialize((String)e.getKey(), (Value)e.getValue());
            }
            return "";
        }).filter(OutputFormatter::isNotBlank).collect(Collectors.joining("; ")).replaceAll(UNNAMED_PATTERN_STRING, "");
        if (!result2.isEmpty()) {
            this.update(columns, OTHER, result2.length());
        }
        return result2;
    }

    @Nonnull
    private String format(@Nonnull Double v) {
        if (v.isNaN()) {
            return v.toString();
        }
        return String.valueOf(Math.round(v));
    }

    static final class Pair<T1, T2> {
        final T1 _1;
        final T2 _2;

        private Pair(T1 _1, T2 _2) {
            this._1 = _1;
            this._2 = _2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return this._1.equals(pair._1) && this._2.equals(pair._2);
        }

        public int hashCode() {
            return 31 * this._1.hashCode() + this._2.hashCode();
        }

        public static <T1, T2> Pair<T1, T2> of(T1 _1, T2 _2) {
            return new Pair<T1, T2>(_1, _2);
        }
    }

    static class Fork
    extends Level {
        private final int level;

        Fork(int level) {
            this.level = level;
        }

        @Override
        Level child() {
            return new Child(this.level);
        }

        @Override
        Level fork() {
            return new Fork(this.level + 1);
        }

        @Override
        String line() {
            return OutputFormatter.repeat("| ", this.level - 1) + "+";
        }

        @Override
        Optional<String> connector() {
            return Optional.of(OutputFormatter.repeat("| ", this.level - 2) + "|\\");
        }
    }

    static class Child
    extends Level {
        private final int level;

        Child(int level) {
            this.level = level;
        }

        @Override
        Level child() {
            return new Child(this.level);
        }

        @Override
        Level fork() {
            return new Fork(this.level + 1);
        }

        @Override
        String line() {
            return OutputFormatter.repeat("| ", this.level - 1) + "+";
        }

        @Override
        Optional<String> connector() {
            return Optional.of(OutputFormatter.repeat("| ", this.level));
        }
    }

    static class Root
    extends Level {
        Root() {
        }

        @Override
        Level child() {
            return new Child(1);
        }

        @Override
        Level fork() {
            return new Fork(2);
        }

        @Override
        String line() {
            return "+";
        }

        @Override
        Optional<String> connector() {
            return Optional.empty();
        }
    }

    static abstract class Level {
        Level() {
        }

        abstract Level child();

        abstract Level fork();

        abstract String line();

        abstract Optional<String> connector();
    }

    static class Right
    extends Justified {
        Right(String text) {
            super(text);
        }
    }

    static class Left
    extends Justified {
        Left(String text) {
            super(text);
        }
    }

    static abstract class Justified {
        final int length;
        final String text;

        Justified(String text) {
            this.length = text.length();
            this.text = text;
        }
    }

    static class Line {
        private final String tree;
        private final Map<String, Justified> details;
        private final Optional<String> connection;

        Line(String tree, Map<String, Justified> details2, Optional<String> connection) {
            this.tree = tree;
            this.details = details2;
            this.connection = connection == null ? Optional.empty() : connection;
        }

        Justified get(String key) {
            if (key.equals(TablePlanFormatter.OPERATOR)) {
                return new Left(this.tree);
            }
            return this.details.getOrDefault(key, new Left(""));
        }
    }
}

