/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.util.Validator;

public class Validators {
    public static final Validator<File> REGEX_FILE_EXISTS = file -> {
        if (Validators.matchingFiles(file).isEmpty()) {
            throw new IllegalArgumentException("File '" + file + "' doesn't exist");
        }
    };
    public static final Validator<File> DIRECTORY_IS_WRITABLE = value2 -> {
        if (value2.mkdirs()) {
            return;
        }
        File test2 = new File((File)value2, "_______test___");
        try {
            test2.createNewFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Directory '" + value2 + "' not writable: " + e.getMessage());
        }
        finally {
            test2.delete();
        }
    };
    public static final Validator<File> CONTAINS_NO_EXISTING_DATABASE = value2 -> {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            if (Validators.isExistingDatabase((FileSystemAbstraction)fileSystem, DatabaseLayout.of((File)value2))) {
                throw new IllegalArgumentException("Directory '" + value2 + "' already contains a database");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };
    public static final Validator<File> CONTAINS_EXISTING_DATABASE = dbDir -> {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            if (!Validators.isExistingDatabase((FileSystemAbstraction)fileSystem, DatabaseLayout.of((File)dbDir))) {
                throw new IllegalArgumentException("Directory '" + dbDir + "' does not contain a database");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };

    private Validators() {
    }

    static List<File> matchingFiles(File fileWithRegexInName) {
        File parent2 = fileWithRegexInName.getAbsoluteFile().getParentFile();
        if (parent2 == null || !parent2.exists()) {
            throw new IllegalArgumentException("Directory of " + fileWithRegexInName + " doesn't exist");
        }
        Pattern pattern = Pattern.compile(fileWithRegexInName.getName());
        ArrayList<File> files2 = new ArrayList<File>();
        for (File file : parent2.listFiles()) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            files2.add(file);
        }
        return files2;
    }

    private static boolean isExistingDatabase(FileSystemAbstraction fileSystem, DatabaseLayout layout) {
        return fileSystem.fileExists(layout.metadataStore());
    }

    public static Validator<String> inList(String[] validStrings) {
        return value2 -> {
            if (Arrays.stream(validStrings).noneMatch(s2 -> s2.equals(value2))) {
                throw new IllegalArgumentException("'" + value2 + "' found but must be one of: " + Arrays.toString(validStrings) + ".");
            }
        };
    }

    public static <T> Validator<T[]> atLeast(String key, int length2) {
        return value2 -> {
            if (((Object[])value2).length < length2) {
                throw new IllegalArgumentException("Expected '" + key + "' to have at least " + length2 + " valid item" + (length2 == 1 ? "" : "s") + ", but had " + ((Object[])value2).length + " " + Arrays.toString(value2));
            }
        };
    }

    public static <T> Validator<T> emptyValidator() {
        return value2 -> {};
    }

    public static <T> Validator<T> all(Validator<T> ... validators) {
        return value2 -> {
            for (Validator validator : validators) {
                validator.validate(value2);
            }
        };
    }
}

