/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV2_3;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;

public enum LogEntryVersion {
    V2_3(-5, LogEntryParsersV2_3.class),
    V3_0(-6, LogEntryParsersV2_3.class),
    V2_3_5(-8, LogEntryParsersV2_3.class),
    V3_0_2(-9, LogEntryParsersV2_3.class),
    V3_0_10(-10, LogEntryParsersV2_3.class);

    public static final LogEntryVersion CURRENT;
    private static final byte LOWEST_VERSION;
    private static final LogEntryVersion[] ALL;
    private static final LogEntryVersion[] LOOKUP_BY_VERSION;
    private final byte version;
    private final LogEntryParser<LogEntry>[] entryTypes;

    private LogEntryVersion(int version, Class<? extends Enum<? extends LogEntryParser<? extends LogEntry>>> cls) {
        this.entryTypes = new LogEntryParser[LogEntryVersion.highestCode(cls) + 1];
        for (Enum<? extends LogEntryParser<? extends LogEntry>> parser : cls.getEnumConstants()) {
            LogEntryParser candidate;
            this.entryTypes[candidate.byteCode()] = candidate = (LogEntryParser)((Object)parser);
        }
        this.version = LogEntryVersion.safeCastToByte(version);
    }

    public byte byteCode() {
        return this.version;
    }

    public LogEntryParser<LogEntry> entryParser(byte type) {
        LogEntryParser<LogEntry> candidate;
        LogEntryParser<LogEntry> logEntryParser = candidate = type >= 0 && type < this.entryTypes.length ? this.entryTypes[type] : null;
        if (candidate == null) {
            throw new IllegalArgumentException("Unknown entry type " + type + " for version " + this.version);
        }
        return candidate;
    }

    public static boolean moreRecentVersionExists(LogEntryVersion version) {
        return version.version > LogEntryVersion.CURRENT.version;
    }

    public static LogEntryVersion byVersion(byte version) {
        byte positiveVersion = -version;
        if (positiveVersion >= LOWEST_VERSION && positiveVersion < LOOKUP_BY_VERSION.length) {
            return LOOKUP_BY_VERSION[positiveVersion];
        }
        byte positiveCurrentVersion = -CURRENT.byteCode();
        if (positiveVersion > positiveCurrentVersion) {
            throw new UnsupportedLogVersionException(String.format("Transaction logs contains entries with prefix %d, and the highest supported prefix is %d. This indicates that the log files originates from a newer version of neo4j.", positiveVersion, positiveCurrentVersion));
        }
        throw new UnsupportedLogVersionException(String.format("Transaction logs contains entries with prefix %d, and the lowest supported prefix is %d. This indicates that the log files originates from an older version of neo4j, which we don't support migrations from.", positiveVersion, LOWEST_VERSION));
    }

    private static void put(LogEntryVersion[] array, int index, LogEntryVersion version) {
        array[index] = version;
    }

    private static byte safeCastToByte(int value2) {
        boolean reversed2 = false;
        if (value2 < 0) {
            value2 ^= 0xFFFFFFFF;
            reversed2 = true;
        }
        if ((value2 & 0xFFFFFF00) != 0) {
            throw new Error(String.format("Bad version %d, must be contained within one byte", value2));
        }
        return (byte)(reversed2 ? ~value2 : value2);
    }

    private static int highestCode(Class<? extends Enum<? extends LogEntryParser<? extends LogEntry>>> cls) {
        int highestCode = 0;
        for (Enum<? extends LogEntryParser<? extends LogEntry>> parser : cls.getEnumConstants()) {
            LogEntryParser candidate = (LogEntryParser)((Object)parser);
            highestCode = Math.max(highestCode, candidate.byteCode());
        }
        return highestCode;
    }

    static {
        CURRENT = V3_0_10;
        LOWEST_VERSION = -V2_3.byteCode();
        ALL = LogEntryVersion.values();
        LOOKUP_BY_VERSION = new LogEntryVersion[-CURRENT.byteCode() + 1];
        for (LogEntryVersion version : ALL) {
            LogEntryVersion.put(LOOKUP_BY_VERSION, -version.byteCode(), version);
        }
    }
}

