/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThresholdPolicy;
import org.neo4j.kernel.impl.transaction.log.checkpoint.PeriodicThresholdPolicy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.SystemNanoClock;

public interface CheckPointThreshold {
    public static final long DEFAULT_CHECKING_FREQUENCY_MILLIS = TimeUnit.SECONDS.toMillis(10L);

    public void initialize(long var1);

    public boolean isCheckPointingNeeded(long var1, Consumer<String> var3);

    public void checkPointHappened(long var1);

    public long checkFrequencyMillis();

    public static CheckPointThreshold createThreshold(Config config, SystemNanoClock clock, LogPruning logPruning, LogProvider logProvider) {
        CheckPointThresholdPolicy policy;
        String policyName = config.get(GraphDatabaseSettings.check_point_policy);
        try {
            policy = CheckPointThresholdPolicy.loadPolicy(policyName);
        }
        catch (NoSuchElementException e) {
            logProvider.getLog(CheckPointThreshold.class).warn("Could not load check point policy '" + GraphDatabaseSettings.check_point_policy.name() + "=" + policyName + "'. Using default policy instead.", (Throwable)e);
            policy = new PeriodicThresholdPolicy();
        }
        return policy.createThreshold(config, clock, logPruning, logProvider);
    }

    public static CheckPointThreshold or(final CheckPointThreshold ... thresholds) {
        return new CheckPointThreshold(){

            @Override
            public void initialize(long transactionId) {
                for (CheckPointThreshold threshold : thresholds) {
                    threshold.initialize(transactionId);
                }
            }

            @Override
            public boolean isCheckPointingNeeded(long transactionId, Consumer<String> consumer) {
                for (CheckPointThreshold threshold : thresholds) {
                    if (!threshold.isCheckPointingNeeded(transactionId, consumer)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void checkPointHappened(long transactionId) {
                for (CheckPointThreshold threshold : thresholds) {
                    threshold.checkPointHappened(transactionId);
                }
            }

            @Override
            public long checkFrequencyMillis() {
                return Stream.of(thresholds).mapToLong(CheckPointThreshold::checkFrequencyMillis).min().orElse(DEFAULT_CHECKING_FREQUENCY_MILLIS);
            }
        };
    }
}

