/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.kernel.impl.index.schema.RawBits;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class NumberIndexKey
extends NativeIndexSingleValueKey<NumberIndexKey> {
    static final int SIZE = 17;
    byte type;
    long rawValueBits;

    NumberIndexKey() {
    }

    @Override
    protected Value assertCorrectType(Value value2) {
        if (!Values.isNumberValue(value2)) {
            throw new IllegalArgumentException("Key layout does only support numbers, tried to create key from " + value2);
        }
        return value2;
    }

    @Override
    NumberValue asValue() {
        return RawBits.asNumberValue(this.rawValueBits, this.type);
    }

    @Override
    void initValueAsLowest(ValueGroup valueGroups) {
        this.writeFloatingPoint(Double.NEGATIVE_INFINITY);
    }

    @Override
    void initValueAsHighest(ValueGroup valueGroups) {
        this.writeFloatingPoint(Double.POSITIVE_INFINITY);
    }

    @Override
    int compareValueTo(NumberIndexKey other2) {
        return RawBits.compare(this.rawValueBits, this.type, other2.rawValueBits, other2.type);
    }

    public String toString() {
        return String.format("type=%d,rawValue=%d,value=%s,entityId=%d", this.type, this.rawValueBits, this.asValue(), this.getEntityId());
    }

    @Override
    public void writeInteger(byte value2) {
        this.type = 0;
        this.rawValueBits = value2;
    }

    @Override
    public void writeInteger(short value2) {
        this.type = 1;
        this.rawValueBits = value2;
    }

    @Override
    public void writeInteger(int value2) {
        this.type = (byte)2;
        this.rawValueBits = value2;
    }

    @Override
    public void writeInteger(long value2) {
        this.type = (byte)3;
        this.rawValueBits = value2;
    }

    @Override
    public void writeFloatingPoint(float value2) {
        this.type = (byte)4;
        this.rawValueBits = Float.floatToIntBits(value2);
    }

    @Override
    public void writeFloatingPoint(double value2) {
        this.type = (byte)5;
        this.rawValueBits = Double.doubleToLongBits(value2);
    }
}

