/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.coreapi.ExplicitIndexProxy;
import org.neo4j.kernel.impl.coreapi.IndexProvider;
import org.neo4j.kernel.impl.coreapi.RelationshipExplicitIndexProxy;

public class IndexProviderImpl
implements IndexProvider {
    private final Supplier<KernelTransaction> transactionBridge;
    private final GraphDatabaseService gds;

    public IndexProviderImpl(GraphDatabaseService gds, Supplier<KernelTransaction> transactionBridge) {
        this.gds = gds;
        this.transactionBridge = transactionBridge;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Index<Node> getOrCreateNodeIndex(String indexName, Map<String, String> customConfiguration) {
        KernelTransaction ktx = this.transactionBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            if (!ktx.indexRead().nodeExplicitIndexExists(indexName, customConfiguration)) {
                ktx.indexWrite().nodeExplicitIndexCreateLazily(indexName, customConfiguration);
            }
            ExplicitIndexProxy<Node> explicitIndexProxy = new ExplicitIndexProxy<Node>(indexName, ExplicitIndexProxy.NODE, this.gds, this.transactionBridge);
            return explicitIndexProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RelationshipIndex getOrCreateRelationshipIndex(String indexName, Map<String, String> customConfiguration) {
        KernelTransaction ktx = this.transactionBridge.get();
        try (Statement ignore = ktx.acquireStatement();){
            if (!ktx.indexRead().relationshipExplicitIndexExists(indexName, customConfiguration)) {
                ktx.indexWrite().relationshipExplicitIndexCreateLazily(indexName, customConfiguration);
            }
            RelationshipExplicitIndexProxy relationshipExplicitIndexProxy = new RelationshipExplicitIndexProxy(indexName, this.gds, this.transactionBridge);
            return relationshipExplicitIndexProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }
}

