/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.store.MultipleUnderlyingStorageExceptions;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

class IndexUpdaterMap
implements AutoCloseable,
Iterable<IndexUpdater> {
    private final IndexUpdateMode indexUpdateMode;
    private final IndexMap indexMap;
    private final Map<SchemaDescriptor, IndexUpdater> updaterMap;

    IndexUpdaterMap(IndexMap indexMap, IndexUpdateMode indexUpdateMode) {
        this.indexUpdateMode = indexUpdateMode;
        this.indexMap = indexMap;
        this.updaterMap = new HashMap<SchemaDescriptor, IndexUpdater>();
    }

    IndexUpdater getUpdater(SchemaDescriptor descriptor) {
        IndexProxy indexProxy;
        IndexUpdater updater = this.updaterMap.get(descriptor);
        if (null == updater && null != (indexProxy = this.indexMap.getIndexProxy(descriptor))) {
            updater = indexProxy.newUpdater(this.indexUpdateMode);
            this.updaterMap.put(descriptor, updater);
        }
        return updater;
    }

    @Override
    public void close() throws UnderlyingStorageException {
        HashSet<Pair> exceptions2 = null;
        for (Map.Entry<SchemaDescriptor, IndexUpdater> updaterEntry : this.updaterMap.entrySet()) {
            IndexUpdater updater = updaterEntry.getValue();
            try {
                updater.close();
            }
            catch (UncheckedIOException | IndexEntryConflictException e) {
                if (null == exceptions2) {
                    exceptions2 = new HashSet<Pair>();
                }
                exceptions2.add(Pair.of((Object)updaterEntry.getKey(), (Object)new UnderlyingStorageException(e)));
            }
        }
        this.clear();
        if (null != exceptions2) {
            throw new MultipleUnderlyingStorageExceptions(exceptions2);
        }
    }

    public void clear() {
        this.updaterMap.clear();
    }

    public boolean isEmpty() {
        return this.updaterMap.isEmpty();
    }

    public int size() {
        return this.updaterMap.size();
    }

    @Override
    public Iterator<IndexUpdater> iterator() {
        return new PrefetchingIterator<IndexUpdater>(){
            private Iterator<SchemaDescriptor> descriptors;
            {
                this.descriptors = IndexUpdaterMap.this.indexMap.descriptors();
            }

            protected IndexUpdater fetchNextOrNull() {
                if (this.descriptors.hasNext()) {
                    return IndexUpdaterMap.this.getUpdater(this.descriptors.next());
                }
                return null;
            }
        };
    }
}

