/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class AbstractIndexKeyLengthValidator
implements Validator<Value> {
    protected final int maxByteLength;
    private final int checkThreshold;

    protected AbstractIndexKeyLengthValidator(int maxByteLength) {
        this.maxByteLength = maxByteLength;
        this.checkThreshold = maxByteLength / 5;
    }

    @Override
    public void validate(Value value2) {
        if (value2 == null || value2 == Values.NO_VALUE) {
            throw new IllegalArgumentException("Null value");
        }
        if (Values.isTextValue(value2) && ((TextValue)value2).length() >= this.checkThreshold) {
            int length2 = this.indexKeyLength(value2);
            this.validateLength(length2);
        }
    }

    void validateLength(int byteLength) {
        if (byteLength > this.maxByteLength) {
            throw new IllegalArgumentException("Property value size is too large for index. Please see index documentation for limitations.");
        }
    }

    protected abstract int indexKeyLength(Value var1);
}

