/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.pool.ConnectionPoolImpl;
import org.neo4j.driver.internal.metrics.ConnectionMetricsListener;
import org.neo4j.driver.internal.metrics.ConnectionPoolMetricsListener;
import org.neo4j.driver.internal.metrics.InternalAbstractMetrics;
import org.neo4j.driver.internal.metrics.InternalConnectionMetrics;
import org.neo4j.driver.internal.metrics.InternalConnectionPoolMetrics;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.NanoTimeBasedListenerEvent;
import org.neo4j.driver.internal.metrics.spi.ConnectionMetrics;
import org.neo4j.driver.internal.metrics.spi.ConnectionPoolMetrics;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.exceptions.ClientException;

public class InternalMetrics
extends InternalAbstractMetrics {
    private final Map<String, ConnectionPoolMetrics> connectionPoolMetrics;
    private final Map<String, ConnectionMetrics> connectionMetrics;
    private final Config config;

    public InternalMetrics(Config config) {
        Objects.requireNonNull(config);
        this.config = config;
        this.connectionPoolMetrics = new ConcurrentHashMap<String, ConnectionPoolMetrics>();
        this.connectionMetrics = new ConcurrentHashMap<String, ConnectionMetrics>();
    }

    @Override
    public void addMetrics(BoltServerAddress serverAddress, ConnectionPoolImpl pool) {
        this.addPoolMetrics(serverAddress, pool);
        this.addConnectionMetrics(serverAddress);
    }

    @Override
    public void beforeCreating(BoltServerAddress serverAddress, ListenerEvent creatingEvent) {
        this.poolMetrics(serverAddress).beforeCreating();
        this.connectionMetrics(serverAddress).beforeCreating(creatingEvent);
    }

    @Override
    public void afterCreated(BoltServerAddress serverAddress, ListenerEvent creatingEvent) {
        this.poolMetrics(serverAddress).afterCreated();
        this.connectionMetrics(serverAddress).afterCreated(creatingEvent);
    }

    @Override
    public void afterFailedToCreate(BoltServerAddress serverAddress) {
        this.poolMetrics(serverAddress).afterFailedToCreate();
    }

    @Override
    public void afterClosed(BoltServerAddress serverAddress) {
        this.poolMetrics(serverAddress).afterClosed();
    }

    @Override
    public void beforeAcquiringOrCreating(BoltServerAddress serverAddress, ListenerEvent listenerEvent) {
        this.poolMetrics(serverAddress).beforeAcquiringOrCreating(listenerEvent);
    }

    @Override
    public void afterAcquiringOrCreating(BoltServerAddress serverAddress) {
        this.poolMetrics(serverAddress).afterAcquiringOrCreating();
    }

    @Override
    public void afterAcquiredOrCreated(BoltServerAddress serverAddress, ListenerEvent listenerEvent) {
        this.poolMetrics(serverAddress).afterAcquiredOrCreated(listenerEvent);
    }

    @Override
    public void afterConnectionCreated(BoltServerAddress serverAddress, ListenerEvent inUseEvent) {
        this.connectionMetrics(serverAddress).acquiredOrCreated(inUseEvent);
    }

    @Override
    public void afterConnectionReleased(BoltServerAddress serverAddress, ListenerEvent inUseEvent) {
        this.connectionMetrics(serverAddress).released(inUseEvent);
    }

    @Override
    public void afterTimedOutToAcquireOrCreate(BoltServerAddress serverAddress) {
        this.poolMetrics(serverAddress).afterTimedOutToAcquireOrCreate();
    }

    @Override
    public ListenerEvent createListenerEvent() {
        return new NanoTimeBasedListenerEvent();
    }

    @Override
    public Map<String, ConnectionPoolMetrics> connectionPoolMetrics() {
        return Collections.unmodifiableMap(this.connectionPoolMetrics);
    }

    @Override
    public Map<String, ConnectionMetrics> connectionMetrics() {
        return Collections.unmodifiableMap(this.connectionMetrics);
    }

    public String toString() {
        return String.format("PoolMetrics=%s, ConnMetrics=%s", this.connectionPoolMetrics, this.connectionMetrics);
    }

    static String serverAddressToUniqueName(BoltServerAddress serverAddress) {
        return String.format("%s:%d", serverAddress.host(), serverAddress.port());
    }

    private ConnectionPoolMetricsListener poolMetrics(BoltServerAddress serverAddress) {
        InternalConnectionPoolMetrics poolMetrics = (InternalConnectionPoolMetrics)this.connectionPoolMetrics.get(InternalMetrics.serverAddressToUniqueName(serverAddress));
        if (poolMetrics == null) {
            throw new ClientException(String.format("Failed to find pool metrics for server `%s` in %s", serverAddress, this.connectionPoolMetrics));
        }
        return poolMetrics;
    }

    private ConnectionMetricsListener connectionMetrics(BoltServerAddress serverAddress) {
        InternalConnectionMetrics connMetrics = (InternalConnectionMetrics)this.connectionMetrics.get(InternalMetrics.serverAddressToUniqueName(serverAddress));
        if (connMetrics == null) {
            throw new ClientException(String.format("Failed to find connection metrics for server `%s` in %s", serverAddress, this.connectionMetrics));
        }
        return connMetrics;
    }

    private void addPoolMetrics(BoltServerAddress serverAddress, ConnectionPool pool) {
        this.connectionPoolMetrics.put(InternalMetrics.serverAddressToUniqueName(serverAddress), new InternalConnectionPoolMetrics(serverAddress, pool, this.config.connectionAcquisitionTimeoutMillis()));
    }

    private void addConnectionMetrics(BoltServerAddress serverAddress) {
        this.connectionMetrics.put(InternalMetrics.serverAddressToUniqueName(serverAddress), new InternalConnectionMetrics(serverAddress, this.config.connectionTimeoutMillis()));
    }
}

