/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import java.time.Duration;
import org.neo4j.driver.internal.metrics.HistogramSnapshot;
import org.neo4j.driver.internal.metrics.spi.Histogram;
import org.neo4j.driver.internal.shaded.org.HdrHistogram.AbstractHistogram;
import org.neo4j.driver.internal.shaded.org.HdrHistogram.ConcurrentHistogram;

public class InternalHistogram
implements Histogram {
    private static final long DEFAULT_HIGHEST_TRACKABLE_NS = Duration.ofMinutes(10L).toNanos();
    private static final int DEFAULT_NUMBER_OF_SIGNIFICANT_VALUE_DIGITS = 3;
    private final AbstractHistogram delegate;

    public InternalHistogram() {
        this(DEFAULT_HIGHEST_TRACKABLE_NS);
    }

    public InternalHistogram(long highestTrackableValueNS) {
        this.delegate = InternalHistogram.createHdrHistogram(highestTrackableValueNS);
    }

    public InternalHistogram(AbstractHistogram histogram) {
        this.delegate = histogram;
    }

    public void recordValue(long value2) {
        long newValue = InternalHistogram.truncateValue(value2, this.delegate);
        this.delegate.recordValue(newValue);
    }

    @Override
    public long min() {
        return this.delegate.getMinValue();
    }

    @Override
    public long max() {
        return this.delegate.getMaxValue();
    }

    @Override
    public double mean() {
        return this.delegate.getMean();
    }

    @Override
    public double stdDeviation() {
        return this.delegate.getStdDeviation();
    }

    @Override
    public long totalCount() {
        return this.delegate.getTotalCount();
    }

    @Override
    public long valueAtPercentile(double percentile) {
        return this.delegate.getValueAtPercentile(percentile);
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    public static ConcurrentHistogram createHdrHistogram(long highestTrackableValue) {
        return new ConcurrentHistogram(highestTrackableValue, 3);
    }

    private static long truncateValue(long value2, AbstractHistogram histogram) {
        if (value2 > histogram.getHighestTrackableValue()) {
            return histogram.getHighestTrackableValue();
        }
        return value2;
    }

    public Histogram snapshot() {
        return new HistogramSnapshot(new InternalHistogram(this.delegate.copy()), this);
    }

    public String toString() {
        return String.format("[min=%sns, max=%sns, mean=%sns, stdDeviation=%s, totalCount=%s]", this.min(), this.max(), this.mean(), this.stdDeviation(), this.totalCount());
    }
}

