/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.ssl.ClientAuth;

public class SslPolicy {
    private final PrivateKey privateKey;
    private final X509Certificate[] keyCertChain;
    private final List<String> ciphers;
    private final String[] tlsVersions;
    private final ClientAuth clientAuth;
    private final TrustManagerFactory trustManagerFactory;
    private final SslProvider sslProvider;

    public SslPolicy(PrivateKey privateKey, X509Certificate[] keyCertChain, List<String> tlsVersions, List<String> ciphers, ClientAuth clientAuth, TrustManagerFactory trustManagerFactory, SslProvider sslProvider) {
        this.privateKey = privateKey;
        this.keyCertChain = keyCertChain;
        this.tlsVersions = tlsVersions == null ? null : tlsVersions.toArray(new String[tlsVersions.size()]);
        this.ciphers = ciphers;
        this.clientAuth = clientAuth;
        this.trustManagerFactory = trustManagerFactory;
        this.sslProvider = sslProvider;
    }

    public SslContext nettyServerContext() throws SSLException {
        return SslContextBuilder.forServer((PrivateKey)this.privateKey, (X509Certificate[])this.keyCertChain).sslProvider(this.sslProvider).clientAuth(this.forNetty(this.clientAuth)).protocols(this.tlsVersions).ciphers(this.ciphers).trustManager(this.trustManagerFactory).build();
    }

    public SslContext nettyClientContext() throws SSLException {
        return SslContextBuilder.forClient().sslProvider(this.sslProvider).keyManager(this.privateKey, this.keyCertChain).protocols(this.tlsVersions).ciphers(this.ciphers).trustManager(this.trustManagerFactory).build();
    }

    private io.netty.handler.ssl.ClientAuth forNetty(ClientAuth clientAuth) {
        switch (clientAuth) {
            case NONE: {
                return io.netty.handler.ssl.ClientAuth.NONE;
            }
            case OPTIONAL: {
                return io.netty.handler.ssl.ClientAuth.OPTIONAL;
            }
            case REQUIRE: {
                return io.netty.handler.ssl.ClientAuth.REQUIRE;
            }
        }
        throw new IllegalArgumentException("Cannot translate to netty equivalent: " + (Object)((Object)clientAuth));
    }

    public SslHandler nettyServerHandler(Channel channel) throws SSLException {
        return this.makeNettyHandler(channel, this.nettyServerContext());
    }

    public SslHandler nettyClientHandler(Channel channel) throws SSLException {
        return this.makeNettyHandler(channel, this.nettyClientContext());
    }

    private SslHandler makeNettyHandler(Channel channel, SslContext sslContext) {
        SSLEngine sslEngine = sslContext.newEngine(channel.alloc());
        if (this.tlsVersions != null) {
            sslEngine.setEnabledProtocols(this.tlsVersions);
        }
        return new SslHandler(sslEngine);
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public X509Certificate[] certificateChain() {
        return this.keyCertChain;
    }

    public KeyStore getKeyStore(char[] keyStorePass, char[] privateKeyPass) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, keyStorePass);
            keyStore.setKeyEntry("key", this.privateKey, privateKeyPass, this.keyCertChain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return keyStore;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public List<String> getCipherSuites() {
        return this.ciphers;
    }

    public String[] getTlsVersions() {
        return this.tlsVersions;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public String toString() {
        return "SslPolicy{keyCertChain=" + this.describeCertChain() + ", ciphers=" + this.ciphers + ", tlsVersions=" + Arrays.toString(this.tlsVersions) + ", clientAuth=" + (Object)((Object)this.clientAuth) + '}';
    }

    private String describeCertificate(X509Certificate certificate) {
        return "Subject: " + certificate.getSubjectDN() + ", Issuer: " + certificate.getIssuerDN();
    }

    private String describeCertChain() {
        List certificates = Arrays.stream(this.keyCertChain).map(this::describeCertificate).collect(Collectors.toList());
        return String.join((CharSequence)", ", certificates);
    }
}

