/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;

class FusionIndexUpdater
extends FusionIndexBase<IndexUpdater>
implements IndexUpdater {
    FusionIndexUpdater(SlotSelector slotSelector, LazyInstanceSelector<IndexUpdater> instanceSelector) {
        super(slotSelector, instanceSelector);
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                ((IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF))).process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = (IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(update.beforeValues(), GROUP_OF));
                IndexUpdater to = (IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF));
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                ((IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF))).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        try {
            this.instanceSelector.close(IndexUpdater::close);
        }
        catch (IOException | RuntimeException | IndexEntryConflictException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

