/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;

public abstract class NodeValue
extends VirtualNodeValue {
    private final long id;

    protected NodeValue(long id2) {
        this.id = id2;
    }

    public abstract TextArray labels();

    public abstract MapValue properties();

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writeNode(this.id, this.labels(), this.properties());
    }

    @Override
    public long id() {
        return this.id;
    }

    public String toString() {
        return String.format("(%d)", this.id);
    }

    @Override
    public String getTypeName() {
        return "Node";
    }

    static class DirectNodeValue
    extends NodeValue {
        private final TextArray labels;
        private final MapValue properties;

        DirectNodeValue(long id2, TextArray labels2, MapValue properties) {
            super(id2);
            assert (labels2 != null);
            assert (properties != null);
            this.labels = labels2;
            this.properties = properties;
        }

        @Override
        public TextArray labels() {
            return this.labels;
        }

        @Override
        public MapValue properties() {
            return this.properties;
        }
    }
}

