/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.StoreConstArgumentAction;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.impl.choice.CollectionArgumentChoice;
import net.sourceforge.argparse4j.impl.type.BooleanArgumentType;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.cli.FailBehavior;
import org.neo4j.shell.cli.Format;

public class CliArgHelper {
    static final Pattern ADDRESS_ARG_PATTERN = Pattern.compile("\\s*(?<scheme>[a-zA-Z0-9+\\-.]+://)?((?<username>\\w+):(?<password>[^\\s]+)@)?(?<host>[a-zA-Z\\d\\-.]+)?(:(?<port>\\d+))?\\s*");

    @Nullable
    public static CliArgs parse(String ... args) {
        String pass;
        Namespace ns;
        ArgumentParser parser = CliArgHelper.setupParser();
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return null;
        }
        Matcher addressMatcher = CliArgHelper.parseAddressMatcher(parser, ns.getString("address"));
        if (addressMatcher == null) {
            return null;
        }
        CliArgs cliArgs = new CliArgs();
        cliArgs.setScheme(addressMatcher.group("scheme"), "bolt://");
        cliArgs.setHost(addressMatcher.group("host"), "localhost");
        String portString = addressMatcher.group("port");
        cliArgs.setPort(portString == null ? 7687 : Integer.parseInt(portString));
        cliArgs.setUsername(addressMatcher.group("username"), "");
        cliArgs.setPassword(addressMatcher.group("password"), "");
        String user = ns.getString("username");
        if (!user.isEmpty()) {
            cliArgs.setUsername(user, cliArgs.getUsername());
        }
        if (!(pass = ns.getString("password")).isEmpty()) {
            cliArgs.setPassword(pass, cliArgs.getPassword());
        }
        cliArgs.setCypher(ns.getString("geequel"));
        cliArgs.setFailBehavior((FailBehavior)((Object)ns.get("fail-behavior")));
        cliArgs.setFormat(Format.parse((String)ns.get("format")));
        cliArgs.setEncryption(ns.getBoolean("encryption"));
        cliArgs.setDebugMode(ns.getBoolean("debug"));
        cliArgs.setNonInteractive(ns.getBoolean("force-non-interactive"));
        cliArgs.setWrap(ns.getBoolean("wrap"));
        cliArgs.setNumSampleRows(ns.getInt("sample-rows"));
        cliArgs.setVersion(ns.getBoolean("version"));
        cliArgs.setDriverVersion(ns.getBoolean("driver-version"));
        return cliArgs;
    }

    @Nullable
    private static Matcher parseAddressMatcher(ArgumentParser parser, String address) {
        Matcher matcher = ADDRESS_ARG_PATTERN.matcher(address);
        if (!matcher.matches()) {
            PrintWriter printWriter = new PrintWriter(System.err);
            parser.printUsage(printWriter);
            printWriter.println("geequel-shell: error: Failed to parse address: '" + address + "'");
            printWriter.println("\n  Address should be of the form: [scheme://][username:password@][host][:port]");
            printWriter.flush();
            return null;
        }
        return matcher;
    }

    private static ArgumentParser setupParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser("geequel-shell").defaultHelp(true).description(String.format("A command line shell where you can execute Geequel against an instance of ONgDB. By default the shell is interactive but you can use it for scripting by passing Geequel directly on the command line or by piping a file with Geequel statements (requires Powershell on Windows).%n%nexample of piping a file:%n  cat some-geequel.txt | geequel-shell", new Object[0]));
        ArgumentGroup connGroup = parser.addArgumentGroup("connection arguments");
        connGroup.addArgument("-a", "--address").help("address and port to connect to").setDefault("bolt://localhost:7687");
        connGroup.addArgument("-u", "--username").setDefault("").help("username to connect as. Can also be specified using environment variable ONGDB_USERNAME");
        connGroup.addArgument("-p", "--password").setDefault("").help("password to connect with. Can also be specified using environment variable ONGDB_PASSWORD");
        connGroup.addArgument("--encryption").help("whether the connection to ONgDB should be encrypted; must be consistent with ONgDB's configuration").type(new BooleanArgumentType()).setDefault((Object)true);
        MutuallyExclusiveGroup failGroup = parser.addMutuallyExclusiveGroup();
        failGroup.addArgument("--fail-fast").help("exit and report failure on first error when reading from file (this is the default behavior)").dest("fail-behavior").setConst((Object)FailBehavior.FAIL_FAST).action(new StoreConstArgumentAction());
        failGroup.addArgument("--fail-at-end").help("exit and report failures at end of input when reading from file").dest("fail-behavior").setConst((Object)FailBehavior.FAIL_AT_END).action(new StoreConstArgumentAction());
        parser.setDefault("fail-behavior", (Object)FailBehavior.FAIL_FAST);
        parser.addArgument("--format").help("desired output format, verbose displays results in tabular format and prints statistics, plain displays data with minimal formatting").choices(new CollectionArgumentChoice<String>(Format.AUTO.name().toLowerCase(), Format.VERBOSE.name().toLowerCase(), Format.PLAIN.name().toLowerCase())).setDefault(Format.AUTO.name().toLowerCase());
        parser.addArgument("--debug").help("print additional debug information").action(new StoreTrueArgumentAction());
        parser.addArgument("--non-interactive").help("force non-interactive mode, only useful if auto-detection fails (like on Windows)").dest("force-non-interactive").action(new StoreTrueArgumentAction());
        parser.addArgument("--sample-rows").help("number of rows sampled to compute table widths (only for format=VERBOSE)").type(new PositiveIntegerType()).dest("sample-rows").setDefault((Object)1000);
        parser.addArgument("--wrap").help("wrap table column values if column is too narrow (only for format=VERBOSE)").type(new BooleanArgumentType()).setDefault((Object)true);
        parser.addArgument("-v", "--version").help("print version of geequel-shell and exit").action(new StoreTrueArgumentAction());
        parser.addArgument("--driver-version").help("print version of the ONgDB Driver used and exit").dest("driver-version").action(new StoreTrueArgumentAction());
        parser.addArgument("geequel").nargs("?").help("an optional string of geequel to execute and then exit");
        return parser;
    }

    private static class PositiveIntegerType
    implements ArgumentType<Integer> {
        private PositiveIntegerType() {
        }

        @Override
        public Integer convert(ArgumentParser parser, Argument arg, String value2) throws ArgumentParserException {
            try {
                int result2 = Integer.parseInt(value2);
                if (result2 < 1) {
                    throw new NumberFormatException(value2);
                }
                return result2;
            }
            catch (NumberFormatException nfe) {
                throw new ArgumentParserException("Invalid value: " + value2, parser);
            }
        }
    }
}

